/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.op;

import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.AuthorizationRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.Scope;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.OIDCScopeValue;

public class AuthenticationRequestDetector {
    public static boolean isLikelyOpenID(AuthorizationRequest request) {
        return request.getScope() != null && request.getScope().contains(OIDCScopeValue.OPENID);
    }

    public static boolean isLikelyOpenID(Map<String, List<String>> queryParams) {
        Scope scope = Scope.parse(MultivaluedMapUtils.getFirstValue(queryParams, "scope"));
        if (scope == null) {
            return false;
        }
        return scope.contains(OIDCScopeValue.OPENID);
    }

    private AuthenticationRequestDetector() {
    }
}

