/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators;

import net.snowflake.client.jdbc.internal.com.nimbusds.jose.JWSAlgorithm;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.State;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.claims.StateHash;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.validators.InvalidHashException;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class StateValidator {
    public static void validate(State state, JWSAlgorithm jwsAlgorithm, StateHash stateHash) throws InvalidHashException {
        StateHash expectedHash = StateHash.compute(state, jwsAlgorithm);
        if (expectedHash == null) {
            throw InvalidHashException.INVALID_STATE_HASH_EXCEPTION;
        }
        if (!expectedHash.equals(stateHash)) {
            throw InvalidHashException.INVALID_STATE_HASH_EXCEPTION;
        }
    }
}

