/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.httpjson;

import java.time.Duration;
import java.time.Instant;
import net.snowflake.client.jdbc.internal.google.api.core.ObsoleteApi;
import net.snowflake.client.jdbc.internal.google.api.gax.httpjson.AutoValue_HttpJsonCallOptions;
import net.snowflake.client.jdbc.internal.google.api.gax.util.TimeConversionUtils;
import net.snowflake.client.jdbc.internal.google.auth.Credentials;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.protobuf.TypeRegistry;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

@AutoValue
public abstract class HttpJsonCallOptions {
    public static final HttpJsonCallOptions DEFAULT = HttpJsonCallOptions.newBuilder().build();

    @Nullable
    @ObsoleteApi(value="Use getTimeoutDuration() instead")
    public final net.snowflake.client.jdbc.internal.threeten.bp.Duration getTimeout() {
        return TimeConversionUtils.toThreetenDuration(this.getTimeoutDuration());
    }

    @Nullable
    public abstract Duration getTimeoutDuration();

    @Nullable
    @ObsoleteApi(value="Use getDeadlineInstant() instead")
    public final net.snowflake.client.jdbc.internal.threeten.bp.Instant getDeadline() {
        return TimeConversionUtils.toThreetenInstant(this.getDeadlineInstant());
    }

    @Nullable
    public abstract Instant getDeadlineInstant();

    @Nullable
    public abstract Credentials getCredentials();

    @Nullable
    public abstract TypeRegistry getTypeRegistry();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_HttpJsonCallOptions.Builder();
    }

    public HttpJsonCallOptions merge(HttpJsonCallOptions inputOptions) {
        TypeRegistry newTypeRegistry;
        Credentials newCredentials;
        Duration newTimeout;
        if (inputOptions == null) {
            return this;
        }
        Builder builder = this.toBuilder();
        Instant newDeadline = inputOptions.getDeadlineInstant();
        if (newDeadline != null) {
            builder.setDeadlineInstant(newDeadline);
        }
        if (inputOptions.getTimeout() != null && (newTimeout = inputOptions.getTimeoutDuration()) != null) {
            builder.setTimeoutDuration(newTimeout);
        }
        if ((newCredentials = inputOptions.getCredentials()) != null) {
            builder.setCredentials(newCredentials);
        }
        if ((newTypeRegistry = inputOptions.getTypeRegistry()) != null) {
            builder.setTypeRegistry(newTypeRegistry);
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @ObsoleteApi(value="Use setTimeoutDuration(java.time.Duration) instead")
        public final Builder setTimeout(net.snowflake.client.jdbc.internal.threeten.bp.Duration value) {
            return this.setTimeoutDuration(TimeConversionUtils.toJavaTimeDuration(value));
        }

        public abstract Builder setTimeoutDuration(Duration var1);

        @ObsoleteApi(value="Use setDeadlineInstant(java.time.Instant) instead")
        public final Builder setDeadline(net.snowflake.client.jdbc.internal.threeten.bp.Instant value) {
            return this.setDeadlineInstant(TimeConversionUtils.toJavaTimeInstant(value));
        }

        public abstract Builder setDeadlineInstant(Instant var1);

        public abstract Builder setCredentials(Credentials var1);

        public abstract Builder setTypeRegistry(TypeRegistry var1);

        public abstract HttpJsonCallOptions build();
    }
}

