/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.resource;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.resource.AutoValue_ResourceTranslator_AttributeMapping;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.resource.GcpResource;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.shadow.semconv.ResourceAttributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

public class ResourceTranslator {
    private static final String UNKNOWN_SERVICE_PREFIX = "unknown_service";
    private static final List<AttributeMapping> GCE_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("zone", ResourceAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("instance_id", ResourceAttributes.HOST_ID));
    private static final List<AttributeMapping> K8S_CONTAINER_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", ResourceAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("namespace_name", ResourceAttributes.K8S_NAMESPACE_NAME), AttributeMapping.create("container_name", ResourceAttributes.K8S_CONTAINER_NAME), AttributeMapping.create("pod_name", ResourceAttributes.K8S_POD_NAME));
    private static final List<AttributeMapping> K8S_POD_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", ResourceAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("namespace_name", ResourceAttributes.K8S_NAMESPACE_NAME), AttributeMapping.create("pod_name", ResourceAttributes.K8S_POD_NAME));
    private static final List<AttributeMapping> K8S_NODE_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", ResourceAttributes.K8S_CLUSTER_NAME), AttributeMapping.create("node_name", ResourceAttributes.K8S_NODE_NAME));
    private static final List<AttributeMapping> K8S_CLUSTER_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION)), AttributeMapping.create("cluster_name", ResourceAttributes.K8S_CLUSTER_NAME));
    private static final List<AttributeMapping> AWS_EC2_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("instance_id", ResourceAttributes.HOST_ID), AttributeMapping.create("region", ResourceAttributes.CLOUD_AVAILABILITY_ZONE), AttributeMapping.create("aws_account", ResourceAttributes.CLOUD_ACCOUNT_ID));
    private static final List<AttributeMapping> GOOGLE_CLOUD_APP_ENGINE_INSTANCE_LABELS = Arrays.asList(AttributeMapping.create("module_id", ResourceAttributes.FAAS_NAME), AttributeMapping.create("version_id", ResourceAttributes.FAAS_VERSION), AttributeMapping.create("instance_id", ResourceAttributes.FAAS_INSTANCE), AttributeMapping.create("location", ResourceAttributes.CLOUD_REGION));
    private static final List<AttributeMapping> GENERIC_TASK_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION), "global"), AttributeMapping.create("namespace", ResourceAttributes.SERVICE_NAMESPACE, ""), AttributeMapping.create("job", Arrays.asList(ResourceAttributes.SERVICE_NAME, ResourceAttributes.FAAS_NAME), ""), AttributeMapping.create("task_id", Arrays.asList(ResourceAttributes.SERVICE_INSTANCE_ID, ResourceAttributes.FAAS_INSTANCE), ""));
    private static final List<AttributeMapping> GENERIC_NODE_LABELS = Arrays.asList(AttributeMapping.create("location", Arrays.asList(ResourceAttributes.CLOUD_AVAILABILITY_ZONE, ResourceAttributes.CLOUD_REGION), "global"), AttributeMapping.create("namespace", ResourceAttributes.SERVICE_NAMESPACE, ""), AttributeMapping.create("node_id", Arrays.asList(ResourceAttributes.HOST_ID, ResourceAttributes.HOST_NAME), ""));

    private ResourceTranslator() {
    }

    public static GcpResource mapResource(Resource resource) {
        String platform = resource.getAttribute(ResourceAttributes.CLOUD_PLATFORM);
        if (platform == null) {
            return ResourceTranslator.mapK8sResourceOrGenericTaskOrNode(resource);
        }
        switch (platform) {
            case "gcp_compute_engine": {
                return ResourceTranslator.mapBase(resource, "gce_instance", GCE_INSTANCE_LABELS);
            }
            case "aws_ec2": {
                return ResourceTranslator.mapBase(resource, "aws_ec2_instance", AWS_EC2_INSTANCE_LABELS);
            }
            case "gcp_app_engine": {
                return ResourceTranslator.mapBase(resource, "gae_instance", GOOGLE_CLOUD_APP_ENGINE_INSTANCE_LABELS);
            }
        }
        return ResourceTranslator.mapK8sResourceOrGenericTaskOrNode(resource);
    }

    private static GcpResource mapK8sResourceOrGenericTaskOrNode(Resource resource) {
        if (resource.getAttribute(ResourceAttributes.K8S_CLUSTER_NAME) != null) {
            if (resource.getAttribute(ResourceAttributes.K8S_CONTAINER_NAME) != null) {
                return ResourceTranslator.mapBase(resource, "k8s_container", K8S_CONTAINER_LABELS);
            }
            if (resource.getAttribute(ResourceAttributes.K8S_POD_NAME) != null) {
                return ResourceTranslator.mapBase(resource, "k8s_pod", K8S_POD_LABELS);
            }
            if (resource.getAttribute(ResourceAttributes.K8S_NODE_NAME) != null) {
                return ResourceTranslator.mapBase(resource, "k8s_node", K8S_NODE_LABELS);
            }
            return ResourceTranslator.mapBase(resource, "k8s_cluster", K8S_CLUSTER_LABELS);
        }
        return ResourceTranslator.genericTaskOrNode(resource);
    }

    private static GcpResource genericTaskOrNode(Resource resource) {
        Map<AttributeKey<?>, Object> attrMap = resource.getAttributes().asMap();
        if ((attrMap.containsKey(ResourceAttributes.SERVICE_NAME) || attrMap.containsKey(ResourceAttributes.FAAS_NAME)) && (attrMap.containsKey(ResourceAttributes.SERVICE_INSTANCE_ID) || attrMap.containsKey(ResourceAttributes.FAAS_INSTANCE))) {
            return ResourceTranslator.mapBase(resource, "generic_task", GENERIC_TASK_LABELS);
        }
        return ResourceTranslator.mapBase(resource, "generic_node", GENERIC_NODE_LABELS);
    }

    private static GcpResource mapBase(Resource resource, String mrType, List<AttributeMapping> mappings) {
        GcpResource.Builder mr = GcpResource.builder();
        mr.setResourceType(mrType);
        for (AttributeMapping mapping : mappings) {
            mapping.fill(resource, mr);
        }
        return mr.build();
    }

    @AutoValue
    public static abstract class AttributeMapping {
        public abstract String getLabelName();

        public abstract List<AttributeKey<?>> getOtelKeys();

        public abstract Optional<String> fallbackLiteral();

        public void fill(Resource resource, GcpResource.Builder builder) {
            for (AttributeKey<?> key : this.getOtelKeys()) {
                Object value2 = resource.getAttribute(key);
                if (value2 == null) continue;
                String stringValue = value2.toString();
                if (key.equals(ResourceAttributes.SERVICE_NAME) && stringValue.startsWith(ResourceTranslator.UNKNOWN_SERVICE_PREFIX)) continue;
                builder.addResourceLabels(this.getLabelName(), stringValue);
                return;
            }
            if (this.getOtelKeys().contains(ResourceAttributes.SERVICE_NAME) && Objects.nonNull(resource.getAttribute(ResourceAttributes.SERVICE_NAME))) {
                builder.addResourceLabels(this.getLabelName(), resource.getAttribute(ResourceAttributes.SERVICE_NAME));
                return;
            }
            this.fallbackLiteral().ifPresent(value -> builder.addResourceLabels(this.getLabelName(), (String)value));
        }

        public static AttributeMapping create(String labelName, AttributeKey<?> otelKey) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, Collections.singletonList(otelKey), Optional.empty());
        }

        public static AttributeMapping create(String labelName, AttributeKey<?> otelKey, String fallbackLiteral) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, Collections.singletonList(otelKey), Optional.of(fallbackLiteral));
        }

        public static AttributeMapping create(String labelName, List<AttributeKey<?>> otelKeys) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, otelKeys, Optional.empty());
        }

        public static AttributeMapping create(String labelName, List<AttributeKey<?>> otelKeys, String fallbackLiteral) {
            return new AutoValue_ResourceTranslator_AttributeMapping(labelName, otelKeys, Optional.of(fallbackLiteral));
        }
    }
}

