/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.function.Function;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.BidiStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ClientStreamingCallable;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BidiResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GapicBidiWritableByteChannelSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GapicWritableByteChannelSessionBuilder;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnifiedOpts;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.google.storage.v2.BidiWriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.BidiWriteObjectResponse;
import net.snowflake.client.jdbc.internal.google.storage.v2.StartResumableWriteRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.StartResumableWriteResponse;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectResponse;

final class GapicUploadSessionBuilder {
    private GapicUploadSessionBuilder() {
    }

    static GapicUploadSessionBuilder create() {
        return new GapicUploadSessionBuilder();
    }

    GapicWritableByteChannelSessionBuilder byteChannel(ClientStreamingCallable<WriteObjectRequest, WriteObjectResponse> write) {
        return new GapicWritableByteChannelSessionBuilder(write);
    }

    GapicBidiWritableByteChannelSessionBuilder bidiByteChannel(BidiStreamingCallable<BidiWriteObjectRequest, BidiWriteObjectResponse> write) {
        return new GapicBidiWritableByteChannelSessionBuilder(write);
    }

    ApiFuture<ResumableWrite> resumableWrite(UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> callable, WriteObjectRequest writeObjectRequest, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        StartResumableWriteRequest.Builder b = StartResumableWriteRequest.newBuilder();
        if (writeObjectRequest.hasWriteObjectSpec()) {
            b.setWriteObjectSpec(writeObjectRequest.getWriteObjectSpec());
        }
        if (writeObjectRequest.hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(writeObjectRequest.getCommonObjectRequestParams());
        }
        if (writeObjectRequest.hasObjectChecksums()) {
            b.setObjectChecksums(writeObjectRequest.getObjectChecksums());
        }
        StartResumableWriteRequest req = opts.startResumableWriteRequest().apply(b).build();
        Function<String, WriteObjectRequest> f = uploadId -> writeObjectRequest.toBuilder().clearWriteObjectSpec().setUploadId((String)uploadId).build();
        ApiFuture<ResumableWrite> futureResumableWrite = ApiFutures.transform(callable.futureCall(req), resp -> new ResumableWrite(req, (StartResumableWriteResponse)resp, f), MoreExecutors.directExecutor());
        return ApiFutures.catchingAsync(futureResumableWrite, Throwable.class, throwable -> ApiFutures.immediateFailedFuture(StorageException.coalesce(throwable)), MoreExecutors.directExecutor());
    }

    ApiFuture<BidiResumableWrite> bidiResumableWrite(UnaryCallable<StartResumableWriteRequest, StartResumableWriteResponse> x, BidiWriteObjectRequest writeObjectRequest, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
        StartResumableWriteRequest.Builder b = StartResumableWriteRequest.newBuilder();
        if (writeObjectRequest.hasWriteObjectSpec()) {
            b.setWriteObjectSpec(writeObjectRequest.getWriteObjectSpec());
        }
        if (writeObjectRequest.hasCommonObjectRequestParams()) {
            b.setCommonObjectRequestParams(writeObjectRequest.getCommonObjectRequestParams());
        }
        if (writeObjectRequest.hasObjectChecksums()) {
            b.setObjectChecksums(writeObjectRequest.getObjectChecksums());
        }
        StartResumableWriteRequest req = opts.startResumableWriteRequest().apply(b).build();
        Function<String, BidiWriteObjectRequest> f = uploadId -> writeObjectRequest.toBuilder().clearWriteObjectSpec().setUploadId((String)uploadId).build();
        return ApiFutures.transform(x.futureCall(req), resp -> new BidiResumableWrite(req, (StartResumableWriteResponse)resp, f), MoreExecutors.directExecutor());
    }
}

