/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager;

import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobWriteSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.ParallelUploadConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.TransferStatus;
import net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager.UploadResult;
import net.snowflake.client.jdbc.internal.google.common.io.ByteStreams;

final class ParallelCompositeUploadCallable
implements Callable<UploadResult> {
    private final Storage storage;
    private final BlobInfo originalBlob;
    private final Path sourceFile;
    private final ParallelUploadConfig parallelUploadConfig;
    private final Storage.BlobWriteOption[] opts;

    public ParallelCompositeUploadCallable(Storage storage, BlobInfo originalBlob, Path sourceFile, ParallelUploadConfig parallelUploadConfig, Storage.BlobWriteOption[] opts) {
        this.storage = storage;
        this.originalBlob = originalBlob;
        this.sourceFile = sourceFile;
        this.parallelUploadConfig = parallelUploadConfig;
        this.opts = opts;
    }

    @Override
    public UploadResult call() {
        return this.uploadPCU();
    }

    private UploadResult uploadPCU() {
        BlobWriteSession session = this.storage.blobWriteSession(this.originalBlob, this.opts);
        try (WritableByteChannel writableByteChannel = session.open();
             FileChannel fc = FileChannel.open(this.sourceFile, StandardOpenOption.READ);){
            ByteStreams.copy(fc, writableByteChannel);
        }
        catch (StorageException e) {
            if (this.parallelUploadConfig.isSkipIfExists() && e.getCode() == 412) {
                return UploadResult.newBuilder(this.originalBlob, TransferStatus.SKIPPED).setException(e).build();
            }
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
        catch (Exception e) {
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
        try {
            ApiFuture<BlobInfo> result = session.getResult();
            BlobInfo newBlob = (BlobInfo)result.get(10L, TimeUnit.SECONDS);
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.SUCCESS).setUploadedBlob(newBlob).build();
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return UploadResult.newBuilder(this.originalBlob, TransferStatus.FAILED_TO_FINISH).setException(e).build();
        }
    }
}

