/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ConnectivityState;
import net.snowflake.client.jdbc.internal.grpc.InternalLogId;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.util.ForwardingLoadBalancerHelper;
import net.snowflake.client.jdbc.internal.grpc.util.GracefulSwitchLoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.xds.AddressFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.PriorityLoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsLogger;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

final class PriorityLoadBalancer
extends LoadBalancer {
    private final LoadBalancer.Helper helper;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService executor;
    private final XdsLogger logger;
    private final Map<String, ChildLbState> children = new HashMap<String, ChildLbState>();
    private LoadBalancer.ResolvedAddresses resolvedAddresses;
    private List<String> priorityNames;
    private Map<String, PriorityLoadBalancerProvider.PriorityLbConfig.PriorityChildConfig> priorityConfigs;
    @Nullable
    private String currentPriority;
    private ConnectivityState currentConnectivityState;
    private LoadBalancer.SubchannelPicker currentPicker;
    private boolean handlingResolvedAddresses;

    PriorityLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        this.syncContext = helper.getSynchronizationContext();
        this.executor = helper.getScheduledExecutorService();
        InternalLogId logId = InternalLogId.allocate("priority-lb", helper.getAuthority());
        this.logger = XdsLogger.withLogId(logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created", new Object[0]);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        ChildLbState childLbState;
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        this.resolvedAddresses = resolvedAddresses;
        PriorityLoadBalancerProvider.PriorityLbConfig config = (PriorityLoadBalancerProvider.PriorityLbConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull(config, "missing priority lb config");
        this.priorityNames = config.priorities;
        this.priorityConfigs = config.childConfigs;
        HashSet<String> prioritySet = new HashSet<String>(config.priorities);
        ArrayList<String> childKeys = new ArrayList<String>(this.children.keySet());
        for (String priority : childKeys) {
            if (prioritySet.contains(priority) || (childLbState = this.children.get(priority)) == null) continue;
            childLbState.deactivate();
        }
        this.handlingResolvedAddresses = true;
        for (String priority : this.priorityNames) {
            childLbState = this.children.get(priority);
            if (childLbState == null) continue;
            childLbState.updateResolvedAddresses();
        }
        this.handlingResolvedAddresses = false;
        this.tryNextPriority();
        return Status.OK;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        boolean gotoTransientFailure = true;
        ArrayList<ChildLbState> childValues = new ArrayList<ChildLbState>(this.children.values());
        for (ChildLbState child : childValues) {
            if (!this.priorityNames.contains(child.priority)) continue;
            child.lb.handleNameResolutionError(error);
            gotoTransientFailure = false;
        }
        if (gotoTransientFailure) {
            this.updateOverallState(null, ConnectivityState.TRANSIENT_FAILURE, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error)));
        }
    }

    @Override
    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown", new Object[0]);
        ArrayList<ChildLbState> childValues = new ArrayList<ChildLbState>(this.children.values());
        for (ChildLbState child : childValues) {
            child.tearDown();
        }
        this.children.clear();
    }

    private void tryNextPriority() {
        for (int i = 0; i < this.priorityNames.size(); ++i) {
            ChildLbState child;
            String priority = this.priorityNames.get(i);
            if (!this.children.containsKey(priority)) {
                child = new ChildLbState(priority, this.priorityConfigs.get((Object)priority).ignoreReresolution);
                this.children.put(priority, child);
                this.updateOverallState(priority, ConnectivityState.CONNECTING, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult()));
                child.updateResolvedAddresses();
                return;
            }
            child = this.children.get(priority);
            child.reactivate();
            if (child.connectivityState.equals((Object)ConnectivityState.READY) || child.connectivityState.equals((Object)ConnectivityState.IDLE)) {
                this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Shifted to priority {0}", priority);
                this.updateOverallState(priority, child.connectivityState, child.picker);
                for (int j = i + 1; j < this.priorityNames.size(); ++j) {
                    String p = this.priorityNames.get(j);
                    if (!this.children.containsKey(p)) continue;
                    this.children.get(p).deactivate();
                }
                return;
            }
            if (child.failOverTimer != null && child.failOverTimer.isPending()) {
                this.updateOverallState(priority, child.connectivityState, child.picker);
                return;
            }
            if (!priority.equals(this.currentPriority) || child.connectivityState == ConnectivityState.TRANSIENT_FAILURE) continue;
            this.updateOverallState(priority, child.connectivityState, child.picker);
            return;
        }
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "All priority failed", new Object[0]);
        String lastPriority = this.priorityNames.get(this.priorityNames.size() - 1);
        LoadBalancer.SubchannelPicker errorPicker = this.children.get((Object)lastPriority).picker;
        this.updateOverallState(lastPriority, ConnectivityState.TRANSIENT_FAILURE, errorPicker);
    }

    private void updateOverallState(@Nullable String priority, ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (!(Objects.equals(priority, this.currentPriority) && state.equals((Object)this.currentConnectivityState) && picker.equals(this.currentPicker))) {
            this.currentPriority = priority;
            this.currentConnectivityState = state;
            this.currentPicker = picker;
            this.helper.updateBalancingState(state, picker);
        }
    }

    private final class ChildLbState {
        final String priority;
        final ChildHelper childHelper;
        final GracefulSwitchLoadBalancer lb;
        SynchronizationContext.ScheduledHandle failOverTimer;
        boolean seenReadyOrIdleSinceTransientFailure = false;
        @Nullable
        SynchronizationContext.ScheduledHandle deletionTimer;
        ConnectivityState connectivityState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker picker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());

        ChildLbState(String priority, boolean ignoreReresolution) {
            this.priority = priority;
            this.childHelper = new ChildHelper(ignoreReresolution);
            this.lb = new GracefulSwitchLoadBalancer(this.childHelper);
            this.failOverTimer = PriorityLoadBalancer.this.syncContext.schedule(new FailOverTask(), 10L, TimeUnit.SECONDS, PriorityLoadBalancer.this.executor);
            PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority created: {0}", priority);
        }

        void reactivate() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
                PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority reactivated: {0}", this.priority);
            }
        }

        void deactivate() {
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                return;
            }
            class DeletionTask
            implements Runnable {
                DeletionTask() {
                }

                @Override
                public void run() {
                    ChildLbState.this.tearDown();
                    PriorityLoadBalancer.this.children.remove(ChildLbState.this.priority);
                }
            }
            this.deletionTimer = PriorityLoadBalancer.this.syncContext.schedule(new DeletionTask(), 15L, TimeUnit.MINUTES, PriorityLoadBalancer.this.executor);
            PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority deactivated: {0}", this.priority);
        }

        void tearDown() {
            if (this.failOverTimer.isPending()) {
                this.failOverTimer.cancel();
            }
            if (this.deletionTimer != null && this.deletionTimer.isPending()) {
                this.deletionTimer.cancel();
            }
            this.lb.shutdown();
            PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority deleted: {0}", this.priority);
        }

        void updateResolvedAddresses() {
            PriorityLoadBalancerProvider.PriorityLbConfig config = (PriorityLoadBalancerProvider.PriorityLbConfig)PriorityLoadBalancer.this.resolvedAddresses.getLoadBalancingPolicyConfig();
            this.lb.handleResolvedAddresses(PriorityLoadBalancer.this.resolvedAddresses.toBuilder().setAddresses(AddressFilter.filter(PriorityLoadBalancer.this.resolvedAddresses.getAddresses(), this.priority)).setLoadBalancingPolicyConfig(config.childConfigs.get((Object)this.priority).childConfig).build());
        }

        final class ChildHelper
        extends ForwardingLoadBalancerHelper {
            private final boolean ignoreReresolution;

            ChildHelper(boolean ignoreReresolution) {
                this.ignoreReresolution = ignoreReresolution;
            }

            @Override
            public void refreshNameResolution() {
                if (!this.ignoreReresolution) {
                    this.delegate().refreshNameResolution();
                }
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (!PriorityLoadBalancer.this.children.containsKey(ChildLbState.this.priority)) {
                    return;
                }
                ChildLbState.this.connectivityState = newState;
                ChildLbState.this.picker = newPicker;
                if (ChildLbState.this.deletionTimer != null && ChildLbState.this.deletionTimer.isPending()) {
                    return;
                }
                if (newState.equals((Object)ConnectivityState.CONNECTING)) {
                    if (!ChildLbState.this.failOverTimer.isPending() && ChildLbState.this.seenReadyOrIdleSinceTransientFailure) {
                        ChildLbState.this.failOverTimer = PriorityLoadBalancer.this.syncContext.schedule(new FailOverTask(), 10L, TimeUnit.SECONDS, PriorityLoadBalancer.this.executor);
                    }
                } else if (newState.equals((Object)ConnectivityState.READY) || newState.equals((Object)ConnectivityState.IDLE)) {
                    ChildLbState.this.seenReadyOrIdleSinceTransientFailure = true;
                    ChildLbState.this.failOverTimer.cancel();
                } else if (newState.equals((Object)ConnectivityState.TRANSIENT_FAILURE)) {
                    ChildLbState.this.seenReadyOrIdleSinceTransientFailure = false;
                    ChildLbState.this.failOverTimer.cancel();
                }
                if (!PriorityLoadBalancer.this.handlingResolvedAddresses) {
                    PriorityLoadBalancer.this.tryNextPriority();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return PriorityLoadBalancer.this.helper;
            }
        }

        final class FailOverTask
        implements Runnable {
            FailOverTask() {
            }

            @Override
            public void run() {
                if (ChildLbState.this.deletionTimer != null && ChildLbState.this.deletionTimer.isPending()) {
                    return;
                }
                ChildLbState.this.picker = new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(Status.UNAVAILABLE.withDescription("Connection timeout for priority " + ChildLbState.this.priority)));
                PriorityLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Priority {0} failed over to next", ChildLbState.this.priority);
                PriorityLoadBalancer.this.currentPriority = null;
                PriorityLoadBalancer.this.tryNextPriority();
            }
        }
    }
}

