/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.snowflake.client.jdbc.internal.google.auto.value.AutoValue;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.protobuf.Any;
import net.snowflake.client.jdbc.internal.google.protobuf.GeneratedMessage;
import net.snowflake.client.jdbc.internal.google.protobuf.InvalidProtocolBufferException;
import net.snowflake.client.jdbc.internal.google.protobuf.Message;
import net.snowflake.client.jdbc.internal.google.protobuf.util.Durations;
import net.snowflake.client.jdbc.internal.grpc.xds.AutoValue_XdsListenerResource_LdsUpdate;
import net.snowflake.client.jdbc.internal.grpc.xds.ConfigOrError;
import net.snowflake.client.jdbc.internal.grpc.xds.EnvoyServerProtoData;
import net.snowflake.client.jdbc.internal.grpc.xds.Filter;
import net.snowflake.client.jdbc.internal.grpc.xds.FilterRegistry;
import net.snowflake.client.jdbc.internal.grpc.xds.RouterFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.TlsContextManager;
import net.snowflake.client.jdbc.internal.grpc.xds.VirtualHost;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsClusterResource;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsRouteConfigureResource;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsClient;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsResourceType;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.udpa.udpa.type.v1.TypedStruct;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.CidrRange;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HttpProtocolOptions;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.TrafficDirection;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChain;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.FilterChainMatch;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Listener;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.HttpFilter;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.filters.network.http_connection_manager.v3.Rds;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.DownstreamTlsContext;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

class XdsListenerResource
extends XdsResourceType<LdsUpdate> {
    static final String ADS_TYPE_URL_LDS = "type.googleapis.com/envoy.config.listener.v3.Listener";
    static final String TYPE_URL_HTTP_CONNECTION_MANAGER = "type.googleapis.com/envoy.extensions.filters.network.http_connection_manager.v3.HttpConnectionManager";
    private static final String TRANSPORT_SOCKET_NAME_TLS = "envoy.transport_sockets.tls";
    private static final XdsListenerResource instance = new XdsListenerResource();
    private static final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();

    XdsListenerResource() {
    }

    static XdsListenerResource getInstance() {
        return instance;
    }

    @Override
    @Nullable
    protected String extractResourceName(Message unpackedResource) {
        if (!(unpackedResource instanceof Listener)) {
            return null;
        }
        return ((Listener)unpackedResource).getName();
    }

    @Override
    public String typeName() {
        return "LDS";
    }

    @Override
    protected Class<Listener> unpackedClassName() {
        return Listener.class;
    }

    @Override
    public String typeUrl() {
        return ADS_TYPE_URL_LDS;
    }

    @Override
    public boolean shouldRetrieveResourceKeysForArgs() {
        return false;
    }

    @Override
    protected boolean isFullStateOfTheWorld() {
        return true;
    }

    @Override
    protected LdsUpdate doParse(XdsResourceType.Args args, Message unpackedMessage) throws XdsResourceType.ResourceInvalidException {
        if (!(unpackedMessage instanceof Listener)) {
            throw new XdsResourceType.ResourceInvalidException("Invalid message type: " + unpackedMessage.getClass());
        }
        Listener listener = (Listener)unpackedMessage;
        if (listener.hasApiListener()) {
            return this.processClientSideListener(listener);
        }
        return this.processServerSideListener(listener, args);
    }

    private LdsUpdate processClientSideListener(Listener listener) throws XdsResourceType.ResourceInvalidException {
        HttpConnectionManager hcm;
        try {
            hcm = XdsListenerResource.unpackCompatibleType(listener.getApiListener().getApiListener(), HttpConnectionManager.class, TYPE_URL_HTTP_CONNECTION_MANAGER, null);
        }
        catch (InvalidProtocolBufferException e) {
            throw new XdsResourceType.ResourceInvalidException("Could not parse HttpConnectionManager config from ApiListener", e);
        }
        return LdsUpdate.forApiListener(XdsListenerResource.parseHttpConnectionManager(hcm, filterRegistry, true));
    }

    private LdsUpdate processServerSideListener(Listener proto, XdsResourceType.Args args) throws XdsResourceType.ResourceInvalidException {
        Set certProviderInstances = null;
        if (args.getBootstrapInfo() != null && args.getBootstrapInfo().certProviders() != null) {
            certProviderInstances = args.getBootstrapInfo().certProviders().keySet();
        }
        return LdsUpdate.forTcpListener(XdsListenerResource.parseServerSideListener(proto, (TlsContextManager)args.getSecurityConfig(), filterRegistry, certProviderInstances));
    }

    @VisibleForTesting
    static EnvoyServerProtoData.Listener parseServerSideListener(Listener proto, TlsContextManager tlsContextManager, FilterRegistry filterRegistry, Set<String> certProviderInstances) throws XdsResourceType.ResourceInvalidException {
        if (!proto.getTrafficDirection().equals(TrafficDirection.INBOUND) && !proto.getTrafficDirection().equals(TrafficDirection.UNSPECIFIED)) {
            throw new XdsResourceType.ResourceInvalidException("Listener " + proto.getName() + " with invalid traffic direction: " + proto.getTrafficDirection());
        }
        if (!proto.getListenerFiltersList().isEmpty()) {
            throw new XdsResourceType.ResourceInvalidException("Listener " + proto.getName() + " cannot have listener_filters");
        }
        if (proto.hasUseOriginalDst()) {
            throw new XdsResourceType.ResourceInvalidException("Listener " + proto.getName() + " cannot have use_original_dst set to true");
        }
        String address = null;
        if (proto.getAddress().hasSocketAddress()) {
            SocketAddress socketAddress = proto.getAddress().getSocketAddress();
            address = socketAddress.getAddress();
            switch (socketAddress.getPortSpecifierCase()) {
                case NAMED_PORT: {
                    address = address + ":" + socketAddress.getNamedPort();
                    break;
                }
                case PORT_VALUE: {
                    address = address + ":" + socketAddress.getPortValue();
                    break;
                }
            }
        }
        ImmutableList.Builder filterChains = ImmutableList.builder();
        HashSet<EnvoyServerProtoData.FilterChainMatch> uniqueSet = new HashSet<EnvoyServerProtoData.FilterChainMatch>();
        for (FilterChain fc : proto.getFilterChainsList()) {
            filterChains.add(XdsListenerResource.parseFilterChain(fc, tlsContextManager, filterRegistry, uniqueSet, certProviderInstances));
        }
        EnvoyServerProtoData.FilterChain defaultFilterChain = null;
        if (proto.hasDefaultFilterChain()) {
            defaultFilterChain = XdsListenerResource.parseFilterChain(proto.getDefaultFilterChain(), tlsContextManager, filterRegistry, null, certProviderInstances);
        }
        return EnvoyServerProtoData.Listener.create(proto.getName(), address, (ImmutableList<EnvoyServerProtoData.FilterChain>)filterChains.build(), defaultFilterChain);
    }

    @VisibleForTesting
    static EnvoyServerProtoData.FilterChain parseFilterChain(FilterChain proto, TlsContextManager tlsContextManager, FilterRegistry filterRegistry, Set<EnvoyServerProtoData.FilterChainMatch> uniqueSet, Set<String> certProviderInstances) throws XdsResourceType.ResourceInvalidException {
        HttpConnectionManager hcmProto;
        if (proto.getFiltersCount() != 1) {
            throw new XdsResourceType.ResourceInvalidException("FilterChain " + proto.getName() + " should contain exact one HttpConnectionManager filter");
        }
        net.snowflake.client.jdbc.internal.grpc.xds.shaded.io.envoyproxy.envoy.config.listener.v3.Filter filter = proto.getFiltersList().get(0);
        if (!filter.hasTypedConfig()) {
            throw new XdsResourceType.ResourceInvalidException("FilterChain " + proto.getName() + " contains filter " + filter.getName() + " without typed_config");
        }
        Any any = filter.getTypedConfig();
        if (!any.getTypeUrl().equals(TYPE_URL_HTTP_CONNECTION_MANAGER)) {
            throw new XdsResourceType.ResourceInvalidException("FilterChain " + proto.getName() + " contains filter " + filter.getName() + " with unsupported typed_config type " + any.getTypeUrl());
        }
        try {
            hcmProto = any.unpack(HttpConnectionManager.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new XdsResourceType.ResourceInvalidException("FilterChain " + proto.getName() + " with filter " + filter.getName() + " failed to unpack message", e);
        }
        net.snowflake.client.jdbc.internal.grpc.xds.HttpConnectionManager httpConnectionManager = XdsListenerResource.parseHttpConnectionManager(hcmProto, filterRegistry, false);
        EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext = null;
        if (proto.hasTransportSocket()) {
            DownstreamTlsContext downstreamTlsContextProto;
            if (!TRANSPORT_SOCKET_NAME_TLS.equals(proto.getTransportSocket().getName())) {
                throw new XdsResourceType.ResourceInvalidException("transport-socket with name " + proto.getTransportSocket().getName() + " not supported.");
            }
            try {
                downstreamTlsContextProto = proto.getTransportSocket().getTypedConfig().unpack(DownstreamTlsContext.class);
            }
            catch (InvalidProtocolBufferException e) {
                throw new XdsResourceType.ResourceInvalidException("FilterChain " + proto.getName() + " failed to unpack message", e);
            }
            downstreamTlsContext = EnvoyServerProtoData.DownstreamTlsContext.fromEnvoyProtoDownstreamTlsContext(XdsListenerResource.validateDownstreamTlsContext(downstreamTlsContextProto, certProviderInstances));
        }
        EnvoyServerProtoData.FilterChainMatch filterChainMatch = XdsListenerResource.parseFilterChainMatch(proto.getFilterChainMatch());
        XdsListenerResource.checkForUniqueness(uniqueSet, filterChainMatch);
        return EnvoyServerProtoData.FilterChain.create(proto.getName(), filterChainMatch, httpConnectionManager, downstreamTlsContext, tlsContextManager);
    }

    @VisibleForTesting
    static DownstreamTlsContext validateDownstreamTlsContext(DownstreamTlsContext downstreamTlsContext, Set<String> certProviderInstances) throws XdsResourceType.ResourceInvalidException {
        if (!downstreamTlsContext.hasCommonTlsContext()) {
            throw new XdsResourceType.ResourceInvalidException("common-tls-context is required in downstream-tls-context");
        }
        XdsClusterResource.validateCommonTlsContext(downstreamTlsContext.getCommonTlsContext(), certProviderInstances, true);
        if (downstreamTlsContext.hasRequireSni()) {
            throw new XdsResourceType.ResourceInvalidException("downstream-tls-context with require-sni is not supported");
        }
        DownstreamTlsContext.OcspStaplePolicy ocspStaplePolicy = downstreamTlsContext.getOcspStaplePolicy();
        if (ocspStaplePolicy != DownstreamTlsContext.OcspStaplePolicy.UNRECOGNIZED && ocspStaplePolicy != DownstreamTlsContext.OcspStaplePolicy.LENIENT_STAPLING) {
            throw new XdsResourceType.ResourceInvalidException("downstream-tls-context with ocsp_staple_policy value " + ocspStaplePolicy.name() + " is not supported");
        }
        return downstreamTlsContext;
    }

    private static void checkForUniqueness(Set<EnvoyServerProtoData.FilterChainMatch> uniqueSet, EnvoyServerProtoData.FilterChainMatch filterChainMatch) throws XdsResourceType.ResourceInvalidException {
        if (uniqueSet != null) {
            List<EnvoyServerProtoData.FilterChainMatch> crossProduct = XdsListenerResource.getCrossProduct(filterChainMatch);
            for (EnvoyServerProtoData.FilterChainMatch cur : crossProduct) {
                if (uniqueSet.add(cur)) continue;
                throw new XdsResourceType.ResourceInvalidException("FilterChainMatch must be unique. Found duplicate: " + cur);
            }
        }
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> getCrossProduct(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
        List<EnvoyServerProtoData.FilterChainMatch> expandedList = XdsListenerResource.expandOnPrefixRange(filterChainMatch);
        expandedList = XdsListenerResource.expandOnApplicationProtocols(expandedList);
        expandedList = XdsListenerResource.expandOnSourcePrefixRange(expandedList);
        expandedList = XdsListenerResource.expandOnSourcePorts(expandedList);
        return XdsListenerResource.expandOnServerNames(expandedList);
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnPrefixRange(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        if (filterChainMatch.prefixRanges().isEmpty()) {
            expandedList.add(filterChainMatch);
        } else {
            for (EnvoyServerProtoData.CidrRange cidrRange : filterChainMatch.prefixRanges()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), ImmutableList.of(cidrRange), filterChainMatch.applicationProtocols(), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnApplicationProtocols(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.applicationProtocols().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (String applicationProtocol : filterChainMatch.applicationProtocols()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), ImmutableList.of(applicationProtocol), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnSourcePrefixRange(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.sourcePrefixRanges().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (EnvoyServerProtoData.CidrRange cidrRange : filterChainMatch.sourcePrefixRanges()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), filterChainMatch.applicationProtocols(), ImmutableList.of(cidrRange), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnSourcePorts(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.sourcePorts().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (Integer sourcePort : filterChainMatch.sourcePorts()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), filterChainMatch.applicationProtocols(), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), ImmutableList.of(sourcePort), filterChainMatch.serverNames(), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static List<EnvoyServerProtoData.FilterChainMatch> expandOnServerNames(Collection<EnvoyServerProtoData.FilterChainMatch> set) {
        ArrayList<EnvoyServerProtoData.FilterChainMatch> expandedList = new ArrayList<EnvoyServerProtoData.FilterChainMatch>();
        for (EnvoyServerProtoData.FilterChainMatch filterChainMatch : set) {
            if (filterChainMatch.serverNames().isEmpty()) {
                expandedList.add(filterChainMatch);
                continue;
            }
            for (String serverName : filterChainMatch.serverNames()) {
                expandedList.add(EnvoyServerProtoData.FilterChainMatch.create(filterChainMatch.destinationPort(), filterChainMatch.prefixRanges(), filterChainMatch.applicationProtocols(), filterChainMatch.sourcePrefixRanges(), filterChainMatch.connectionSourceType(), filterChainMatch.sourcePorts(), ImmutableList.of(serverName), filterChainMatch.transportProtocol()));
            }
        }
        return expandedList;
    }

    private static EnvoyServerProtoData.FilterChainMatch parseFilterChainMatch(FilterChainMatch proto) throws XdsResourceType.ResourceInvalidException {
        EnvoyServerProtoData.ConnectionSourceType sourceType;
        ImmutableList.Builder prefixRanges = ImmutableList.builder();
        ImmutableList.Builder sourcePrefixRanges = ImmutableList.builder();
        try {
            for (CidrRange range : proto.getPrefixRangesList()) {
                prefixRanges.add(EnvoyServerProtoData.CidrRange.create(range.getAddressPrefix(), range.getPrefixLen().getValue()));
            }
            for (CidrRange range : proto.getSourcePrefixRangesList()) {
                sourcePrefixRanges.add(EnvoyServerProtoData.CidrRange.create(range.getAddressPrefix(), range.getPrefixLen().getValue()));
            }
        }
        catch (UnknownHostException e) {
            throw new XdsResourceType.ResourceInvalidException("Failed to create CidrRange", e);
        }
        switch (proto.getSourceType()) {
            case ANY: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.ANY;
                break;
            }
            case EXTERNAL: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.EXTERNAL;
                break;
            }
            case SAME_IP_OR_LOOPBACK: {
                sourceType = EnvoyServerProtoData.ConnectionSourceType.SAME_IP_OR_LOOPBACK;
                break;
            }
            default: {
                throw new XdsResourceType.ResourceInvalidException("Unknown source-type: " + proto.getSourceType());
            }
        }
        return EnvoyServerProtoData.FilterChainMatch.create(proto.getDestinationPort().getValue(), (ImmutableList<EnvoyServerProtoData.CidrRange>)prefixRanges.build(), ImmutableList.copyOf(proto.getApplicationProtocolsList()), (ImmutableList<EnvoyServerProtoData.CidrRange>)sourcePrefixRanges.build(), sourceType, ImmutableList.copyOf(proto.getSourcePortsList()), ImmutableList.copyOf(proto.getServerNamesList()), proto.getTransportProtocol());
    }

    @VisibleForTesting
    static net.snowflake.client.jdbc.internal.grpc.xds.HttpConnectionManager parseHttpConnectionManager(HttpConnectionManager proto, FilterRegistry filterRegistry, boolean isForClient) throws XdsResourceType.ResourceInvalidException {
        HttpProtocolOptions options;
        if (proto.getXffNumTrustedHops() != 0) {
            throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager with xff_num_trusted_hops unsupported");
        }
        if (!proto.getOriginalIpDetectionExtensionsList().isEmpty()) {
            throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager with original_ip_detection_extensions unsupported");
        }
        long maxStreamDuration = 0L;
        if (proto.hasCommonHttpProtocolOptions() && (options = proto.getCommonHttpProtocolOptions()).hasMaxStreamDuration()) {
            maxStreamDuration = Durations.toNanos(options.getMaxStreamDuration());
        }
        if (proto.getHttpFiltersList().isEmpty()) {
            throw new XdsResourceType.ResourceInvalidException("Missing HttpFilter in HttpConnectionManager.");
        }
        ArrayList<Filter.NamedFilterConfig> filterConfigs = new ArrayList<Filter.NamedFilterConfig>();
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < proto.getHttpFiltersCount(); ++i) {
            HttpFilter httpFilter = proto.getHttpFiltersList().get(i);
            String filterName = httpFilter.getName();
            if (!names.add(filterName)) {
                throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager contains duplicate HttpFilter: " + filterName);
            }
            XdsResourceType.StructOrError<Filter.FilterConfig> filterConfig = XdsListenerResource.parseHttpFilter(httpFilter, filterRegistry, isForClient);
            if (!(i != proto.getHttpFiltersCount() - 1 || filterConfig != null && XdsListenerResource.isTerminalFilter(filterConfig.getStruct()))) {
                throw new XdsResourceType.ResourceInvalidException("The last HttpFilter must be a terminal filter: " + filterName);
            }
            if (filterConfig == null) continue;
            if (filterConfig.getErrorDetail() != null) {
                throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager contains invalid HttpFilter: " + filterConfig.getErrorDetail());
            }
            if (i < proto.getHttpFiltersCount() - 1 && XdsListenerResource.isTerminalFilter(filterConfig.getStruct())) {
                throw new XdsResourceType.ResourceInvalidException("A terminal HttpFilter must be the last filter: " + filterName);
            }
            filterConfigs.add(new Filter.NamedFilterConfig(filterName, filterConfig.getStruct()));
        }
        if (proto.hasRouteConfig()) {
            List<VirtualHost> virtualHosts = XdsRouteConfigureResource.extractVirtualHosts(proto.getRouteConfig(), filterRegistry);
            return net.snowflake.client.jdbc.internal.grpc.xds.HttpConnectionManager.forVirtualHosts(maxStreamDuration, virtualHosts, filterConfigs);
        }
        if (proto.hasRds()) {
            Rds rds = proto.getRds();
            if (!rds.hasConfigSource()) {
                throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager contains invalid RDS: missing config_source");
            }
            if (!rds.getConfigSource().hasAds() && !rds.getConfigSource().hasSelf()) {
                throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager contains invalid RDS: must specify ADS or self ConfigSource");
            }
            return net.snowflake.client.jdbc.internal.grpc.xds.HttpConnectionManager.forRdsName(maxStreamDuration, rds.getRouteConfigName(), filterConfigs);
        }
        throw new XdsResourceType.ResourceInvalidException("HttpConnectionManager neither has inlined route_config nor RDS");
    }

    private static boolean isTerminalFilter(Filter.FilterConfig filterConfig) {
        return RouterFilter.ROUTER_CONFIG.equals(filterConfig);
    }

    @Nullable
    @VisibleForTesting
    static XdsResourceType.StructOrError<Filter.FilterConfig> parseHttpFilter(HttpFilter httpFilter, FilterRegistry filterRegistry, boolean isForClient) {
        String filterName = httpFilter.getName();
        boolean isOptional = httpFilter.getIsOptional();
        if (!httpFilter.hasTypedConfig()) {
            if (isOptional) {
                return null;
            }
            return XdsResourceType.StructOrError.fromError("HttpFilter [" + filterName + "] is not optional and has no typed config");
        }
        GeneratedMessage rawConfig = httpFilter.getTypedConfig();
        String typeUrl = httpFilter.getTypedConfig().getTypeUrl();
        try {
            if (typeUrl.equals("type.googleapis.com/udpa.type.v1.TypedStruct")) {
                TypedStruct typedStruct = httpFilter.getTypedConfig().unpack(TypedStruct.class);
                typeUrl = typedStruct.getTypeUrl();
                rawConfig = typedStruct.getValue();
            } else if (typeUrl.equals("type.googleapis.com/xds.type.v3.TypedStruct")) {
                net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct newTypedStruct = httpFilter.getTypedConfig().unpack(net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.type.v3.TypedStruct.class);
                typeUrl = newTypedStruct.getTypeUrl();
                rawConfig = newTypedStruct.getValue();
            }
        }
        catch (InvalidProtocolBufferException e) {
            return XdsResourceType.StructOrError.fromError("HttpFilter [" + filterName + "] contains invalid proto: " + e);
        }
        Filter filter = filterRegistry.get(typeUrl);
        if (isForClient && !(filter instanceof Filter.ClientInterceptorBuilder) || !isForClient && !(filter instanceof Filter.ServerInterceptorBuilder)) {
            if (isOptional) {
                return null;
            }
            return XdsResourceType.StructOrError.fromError("HttpFilter [" + filterName + "](" + typeUrl + ") is required but unsupported for " + (isForClient ? "client" : "server"));
        }
        ConfigOrError<? extends Filter.FilterConfig> filterConfig = filter.parseFilterConfig(rawConfig);
        if (filterConfig.errorDetail != null) {
            return XdsResourceType.StructOrError.fromError("Invalid filter config for HttpFilter [" + filterName + "]: " + filterConfig.errorDetail);
        }
        return XdsResourceType.StructOrError.fromStruct((Filter.FilterConfig)filterConfig.config);
    }

    @AutoValue
    static abstract class LdsUpdate
    implements XdsClient.ResourceUpdate {
        LdsUpdate() {
        }

        @Nullable
        abstract net.snowflake.client.jdbc.internal.grpc.xds.HttpConnectionManager httpConnectionManager();

        @Nullable
        abstract EnvoyServerProtoData.Listener listener();

        static LdsUpdate forApiListener(net.snowflake.client.jdbc.internal.grpc.xds.HttpConnectionManager httpConnectionManager) {
            Preconditions.checkNotNull(httpConnectionManager, "httpConnectionManager");
            return new AutoValue_XdsListenerResource_LdsUpdate(httpConnectionManager, null);
        }

        static LdsUpdate forTcpListener(EnvoyServerProtoData.Listener listener) {
            Preconditions.checkNotNull(listener, "listener");
            return new AutoValue_XdsListenerResource_LdsUpdate(null, listener);
        }
    }
}

