/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds.orca;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.protobuf.util.Durations;
import net.snowflake.client.jdbc.internal.grpc.BindableService;
import net.snowflake.client.jdbc.internal.grpc.ExperimentalApi;
import net.snowflake.client.jdbc.internal.grpc.ServerServiceDefinition;
import net.snowflake.client.jdbc.internal.grpc.SynchronizationContext;
import net.snowflake.client.jdbc.internal.grpc.services.InternalMetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.services.MetricRecorder;
import net.snowflake.client.jdbc.internal.grpc.services.MetricReport;
import net.snowflake.client.jdbc.internal.grpc.stub.ServerCallStreamObserver;
import net.snowflake.client.jdbc.internal.grpc.stub.StreamObserver;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.data.orca.v3.OrcaLoadReport;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.service.orca.v3.OpenRcaServiceGrpc;
import net.snowflake.client.jdbc.internal.grpc.xds.shaded.com.github.xds.service.orca.v3.OrcaLoadReportRequest;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9006")
public final class OrcaServiceImpl
implements BindableService {
    private static final Logger logger = Logger.getLogger(OrcaServiceImpl.class.getName());
    public static final long DEFAULT_MIN_REPORT_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(30L);
    private final long minReportIntervalNanos;
    private final ScheduledExecutorService timeService;
    @VisibleForTesting
    final AtomicInteger clientCount = new AtomicInteger(0);
    private MetricRecorder metricRecorder;
    private final RealOrcaServiceImpl delegate = new RealOrcaServiceImpl();

    public static BindableService createService(ScheduledExecutorService timeService, MetricRecorder metricsRecorder, long minInterval, TimeUnit timeUnit) {
        return new OrcaServiceImpl(minInterval, timeUnit, timeService, metricsRecorder);
    }

    public static BindableService createService(ScheduledExecutorService timeService, MetricRecorder metricRecorder) {
        return new OrcaServiceImpl(DEFAULT_MIN_REPORT_INTERVAL_NANOS, TimeUnit.NANOSECONDS, timeService, metricRecorder);
    }

    private OrcaServiceImpl(long minInterval, TimeUnit timeUnit, ScheduledExecutorService timeService, MetricRecorder orcaMetrics) {
        this.minReportIntervalNanos = minInterval > 0L ? timeUnit.toNanos(minInterval) : DEFAULT_MIN_REPORT_INTERVAL_NANOS;
        this.timeService = Preconditions.checkNotNull(timeService, "timeService");
        this.metricRecorder = Preconditions.checkNotNull(orcaMetrics, "orcaMetrics");
    }

    @Override
    public ServerServiceDefinition bindService() {
        return this.delegate.bindService();
    }

    private OrcaLoadReport generateMetricsReport() {
        MetricReport internalReport = InternalMetricRecorder.getMetricReport(this.metricRecorder);
        return OrcaLoadReport.newBuilder().setCpuUtilization(internalReport.getCpuUtilization()).setApplicationUtilization(internalReport.getApplicationUtilization()).setMemUtilization(internalReport.getMemoryUtilization()).setRpsFractional(internalReport.getQps()).setEps(internalReport.getEps()).putAllUtilization(internalReport.getUtilizationMetrics()).build();
    }

    private final class OrcaClient
    implements Runnable {
        final ServerCallStreamObserver<OrcaLoadReport> responseObserver;
        SynchronizationContext.ScheduledHandle periodicReportTimer;
        final long reportIntervalNanos;
        final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t2, Throwable e) {
                logger.log(Level.SEVERE, "Exception!" + e);
            }
        });

        OrcaClient(OrcaLoadReportRequest request, StreamObserver<OrcaLoadReport> responseObserver) {
            this.reportIntervalNanos = Math.max(Durations.toNanos(Preconditions.checkNotNull(request).getReportInterval()), OrcaServiceImpl.this.minReportIntervalNanos);
            this.responseObserver = (ServerCallStreamObserver)responseObserver;
            this.responseObserver.setOnCancelHandler(new Runnable(){

                @Override
                public void run() {
                    OrcaClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (OrcaClient.this.periodicReportTimer != null) {
                                OrcaClient.this.periodicReportTimer.cancel();
                            }
                            OrcaServiceImpl.this.clientCount.getAndDecrement();
                        }
                    });
                }
            });
        }

        @Override
        public void run() {
            if (this.periodicReportTimer != null && this.periodicReportTimer.isPending()) {
                return;
            }
            OrcaLoadReport report = OrcaServiceImpl.this.generateMetricsReport();
            this.responseObserver.onNext(report);
            this.periodicReportTimer = this.syncContext.schedule(this, this.reportIntervalNanos, TimeUnit.NANOSECONDS, OrcaServiceImpl.this.timeService);
        }
    }

    private final class RealOrcaServiceImpl
    extends OpenRcaServiceGrpc.OpenRcaServiceImplBase {
        private RealOrcaServiceImpl() {
        }

        @Override
        public void streamCoreMetrics(OrcaLoadReportRequest request, StreamObserver<OrcaLoadReport> responseObserver) {
            OrcaClient client = new OrcaClient(request, responseObserver);
            client.run();
            OrcaServiceImpl.this.clientCount.getAndIncrement();
        }
    }
}

