/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.tags.unsafe;

import java.util.Collections;
import java.util.Iterator;
import net.snowflake.client.jdbc.internal.grpc.Context;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.opencensus.internal.Utils;
import net.snowflake.client.jdbc.internal.opencensus.tags.Tag;
import net.snowflake.client.jdbc.internal.opencensus.tags.TagContext;

public final class ContextUtils {
    private static final TagContext EMPTY_TAG_CONTEXT = new EmptyTagContext();
    private static final Context.Key<TagContext> TAG_CONTEXT_KEY = Context.keyWithDefault("net.snowflake.client.jdbc.internal.opencensus-tag-context-key", EMPTY_TAG_CONTEXT);

    private ContextUtils() {
    }

    public static Context withValue(Context context, @Nullable TagContext tagContext) {
        return Utils.checkNotNull(context, "context").withValue(TAG_CONTEXT_KEY, tagContext);
    }

    public static TagContext getValue(Context context) {
        TagContext tags = TAG_CONTEXT_KEY.get(context);
        return tags == null ? EMPTY_TAG_CONTEXT : tags;
    }

    @Immutable
    private static final class EmptyTagContext
    extends TagContext {
        private EmptyTagContext() {
        }

        @Override
        protected Iterator<Tag> getIterator() {
            return Collections.emptySet().iterator();
        }
    }
}

