/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.log;

import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

class StdErrOutThresholdAwareConsoleHandler
extends StreamHandler {
    private final ConsoleHandler stdErrConsoleHandler = new ConsoleHandler();
    private final Level threshold;

    public StdErrOutThresholdAwareConsoleHandler(Level threshold) {
        super(System.out, new SimpleFormatter());
        this.threshold = threshold;
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().intValue() > this.threshold.intValue()) {
            this.stdErrConsoleHandler.publish(record);
        } else {
            super.publish(record);
            this.flush();
        }
    }

    @Override
    public void close() {
        this.flush();
        this.stdErrConsoleHandler.close();
    }

    Level getThreshold() {
        return this.threshold;
    }
}

