/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kproject.models;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.drools.compiler.kproject.models.ChannelModelImpl;
import org.drools.compiler.kproject.models.FileLoggerModelImpl;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.drools.compiler.kproject.models.ListenerModelImpl;
import org.drools.compiler.kproject.models.QualifierModelImpl;
import org.drools.compiler.kproject.models.RuleTemplateModelImpl;
import org.drools.compiler.kproject.models.WorkItemHandlerModelImpl;
import org.drools.core.util.AbstractXStreamConverter;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.soup.xstream.XStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class KieModuleMarshaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(KieModuleMarshaller.class);
    static final KieModuleMarshaller MARSHALLER = new KieModuleMarshaller();
    private final XStream xStream = XStreamUtils.createNonTrustingXStream((HierarchicalStreamDriver)new DomDriver());

    private KieModuleMarshaller() {
        this.xStream.addPermission((TypePermission)new WildcardTypePermission(new String[]{"org.drools.compiler.kproject.models.*"}));
        this.xStream.registerConverter((Converter)new KieModuleConverter());
        this.xStream.registerConverter((Converter)new KieBaseModelImpl.KBaseConverter());
        this.xStream.registerConverter((Converter)new KieSessionModelImpl.KSessionConverter());
        this.xStream.registerConverter((Converter)new ListenerModelImpl.ListenerConverter());
        this.xStream.registerConverter((Converter)new QualifierModelImpl.QualifierConverter());
        this.xStream.registerConverter((Converter)new WorkItemHandlerModelImpl.WorkItemHandelerConverter());
        this.xStream.registerConverter((Converter)new ChannelModelImpl.ChannelConverter());
        this.xStream.registerConverter((Converter)new RuleTemplateModelImpl.RuleTemplateConverter());
        this.xStream.alias("kmodule", KieModuleModelImpl.class);
        this.xStream.alias("kbase", KieBaseModelImpl.class);
        this.xStream.alias("ksession", KieSessionModelImpl.class);
        this.xStream.alias("listener", ListenerModelImpl.class);
        this.xStream.alias("qualifier", QualifierModelImpl.class);
        this.xStream.alias("workItemHandler", WorkItemHandlerModelImpl.class);
        this.xStream.alias("channel", ChannelModelImpl.class);
        this.xStream.alias("fileLogger", FileLoggerModelImpl.class);
        this.xStream.alias("ruleTemplate", RuleTemplateModelImpl.class);
        this.xStream.setClassLoader(KieModuleModelImpl.class.getClassLoader());
    }

    public String toXML(KieModuleModel kieProject) {
        return this.xStream.toXML((Object)kieProject);
    }

    public KieModuleModel fromXML(InputStream kModuleStream) {
        byte[] bytes = null;
        try {
            bytes = IoUtils.readBytesFromInputStream((InputStream)kModuleStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        KieModuleValidator.validate(bytes);
        return (KieModuleModel)this.xStream.fromXML((InputStream)new ByteArrayInputStream(bytes));
    }

    public KieModuleModel fromXML(File kModuleFile) {
        KieModuleValidator.validate(kModuleFile);
        return (KieModuleModel)this.xStream.fromXML(kModuleFile);
    }

    public KieModuleModel fromXML(URL kModuleUrl) {
        KieModuleValidator.validate(kModuleUrl);
        return (KieModuleModel)this.xStream.fromXML(kModuleUrl);
    }

    public KieModuleModel fromXML(String kModuleString) {
        KieModuleValidator.validate(kModuleString);
        return (KieModuleModel)this.xStream.fromXML(kModuleString);
    }

    private static class KieModuleValidator {
        private static final Schema schema = KieModuleValidator.loadSchema("org/kie/api/kmodule.xsd");
        private static final Schema oldSchema = KieModuleValidator.loadSchema("org/kie/api/old-kmodule.xsd");

        private KieModuleValidator() {
        }

        private static Schema loadSchema(String xsd) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", ClassLoader.getSystemClassLoader());
                URL url = KieModuleModel.class.getClassLoader().getResource(xsd);
                Schema schema = url != null ? factory.newSchema(url) : null;
                return schema;
            }
            catch (SAXException ex) {
                throw new RuntimeException("Unable to load XSD", ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }

        private static void validate(byte[] bytes) {
            KieModuleValidator.validate((Source)new StreamSource(new ByteArrayInputStream(bytes)), new StreamSource(new ByteArrayInputStream(bytes)));
        }

        private static void validate(File kModuleFile) {
            KieModuleValidator.validate((Source)new StreamSource(kModuleFile), new StreamSource(kModuleFile));
        }

        private static void validate(URL kModuleUrl) {
            String urlString;
            try {
                urlString = kModuleUrl.toURI().toString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            KieModuleValidator.validate((Source)new StreamSource(urlString), new StreamSource(urlString));
        }

        private static void validate(String kModuleString) {
            byte[] bytes = kModuleString.getBytes(IoUtils.UTF8_CHARSET);
            KieModuleValidator.validate(bytes);
        }

        private static void validate(Source source, Source duplicateSource) {
            try {
                KieModuleValidator.validate(source, schema);
            }
            catch (Exception schemaException) {
                try {
                    if (oldSchema != null) {
                        KieModuleValidator.validate(duplicateSource, oldSchema);
                    }
                }
                catch (Exception oldSchemaException) {
                    throw new RuntimeException("XSD validation failed against the new schema (" + schemaException.getMessage() + ") and against the old schema (" + oldSchemaException.getMessage() + ").", schemaException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void validate(Source source, Schema schema) throws SAXException, IOException {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
                Validator validator = schema.newValidator();
                try {
                    validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException notSupportedException) {
                    LOGGER.warn("{} is not supported", (Object)"http://javax.xml.XMLConstants/property/accessExternalDTD");
                }
                try {
                    validator.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
                }
                catch (SAXNotRecognizedException | SAXNotSupportedException notSupportedException) {
                    LOGGER.warn("{} is not supported", (Object)"http://javax.xml.XMLConstants/property/accessExternalSchema");
                }
                validator.validate(source);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public static class KieModuleConverter
    extends AbstractXStreamConverter {
        public KieModuleConverter() {
            super(KieModuleModelImpl.class);
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            KieModuleModelImpl kModule = (KieModuleModelImpl)value;
            this.writePropertyMap(writer, context, "configuration", kModule.getConfProps());
            for (KieBaseModel kBaseModule : kModule.getKieBaseModels().values()) {
                this.writeObject(writer, context, "kbase", kBaseModule);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, final UnmarshallingContext context) {
            final KieModuleModelImpl kModule = new KieModuleModelImpl();
            this.readNodes(reader, new AbstractXStreamConverter.NodeReader(){

                public void onNode(HierarchicalStreamReader reader, String name, String value) {
                    if ("kbase".equals(name)) {
                        KieBaseModelImpl kBaseModule = (KieBaseModelImpl)this.readObject(reader, context, KieBaseModelImpl.class);
                        kModule.getRawKieBaseModels().put(kBaseModule.getName(), kBaseModule);
                        kBaseModule.setKModule(kModule);
                    } else if ("configuration".equals(name)) {
                        kModule.setConfProps(this.readPropertyMap(reader, context));
                    }
                }
            });
            return kModule;
        }
    }
}

