/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;
import java.nio.ByteBuffer;

public class MessageAttributeValueJsonUnmarshaller
implements Unmarshaller<MessageAttributeValue, JsonUnmarshallerContext> {
    private static MessageAttributeValueJsonUnmarshaller instance;

    public MessageAttributeValue unmarshall(JsonUnmarshallerContext context) throws Exception {
        MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("StringValue", targetDepth)) {
                    context.nextToken();
                    messageAttributeValue.setStringValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BinaryValue", targetDepth)) {
                    context.nextToken();
                    messageAttributeValue.setBinaryValue((ByteBuffer)context.getUnmarshaller(ByteBuffer.class).unmarshall((Object)context));
                }
                if (context.testExpression("StringListValues", targetDepth)) {
                    context.nextToken();
                    messageAttributeValue.setStringListValues(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("BinaryListValues", targetDepth)) {
                    context.nextToken();
                    messageAttributeValue.setBinaryListValues(new ListUnmarshaller(context.getUnmarshaller(ByteBuffer.class)).unmarshall(context));
                }
                if (context.testExpression("DataType", targetDepth)) {
                    context.nextToken();
                    messageAttributeValue.setDataType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return messageAttributeValue;
    }

    public static MessageAttributeValueJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageAttributeValueJsonUnmarshaller();
        }
        return instance;
    }
}

