/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.parquet.transforms.input;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.parquet.transforms.input.ParquetField;
import org.apache.hop.parquet.transforms.input.ParquetRowConverter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

public class ParquetRecordMaterializer
extends RecordMaterializer<RowMetaAndData> {
    private final ParquetRowConverter root;
    private final MessageType messageType;
    private final List<ParquetField> fields;
    private final List<Integer> requestedFieldIndexes;
    private final IRowMeta schemaRowMeta;

    public ParquetRecordMaterializer(MessageType messageType, List<ParquetField> fields) {
        this.messageType = messageType;
        this.fields = fields;
        this.requestedFieldIndexes = new ArrayList<Integer>();
        this.schemaRowMeta = new RowMeta();
        for (ParquetField field : fields) {
            int fieldIndex = messageType.getFieldIndex(field.getSourceField());
            if (fieldIndex < 0) {
                throw new RuntimeException("Error finding source field '" + field.getSourceField() + "' in the input file");
            }
            this.requestedFieldIndexes.add(fieldIndex);
            try {
                this.schemaRowMeta.addValueMeta(field.createValueMeta());
            }
            catch (HopException e) {
                throw new RuntimeException("Error creating value of type " + field.getTargetType() + "'", e);
            }
        }
        this.root = new ParquetRowConverter(messageType, this.schemaRowMeta, fields);
    }

    public RowMetaAndData getCurrentRecord() {
        return this.root.getGroup();
    }

    public GroupConverter getRootConverter() {
        return this.root;
    }
}

