/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.client.json.JsonFactory;
import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationQuery;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.JobStatistics;
import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableConstraints;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.storage.v1.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.DataFormat;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.ReadStream;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.extensions.avro.io.AvroSource;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.sdk.extensions.gcp.util.gcsfs.GcsPath;
import org.apache.beam.sdk.extensions.protobuf.ProtoCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_TypedRead;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryIO_Write;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BatchLoads;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryResourceNaming;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageQuerySource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageStreamSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageTableSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTables;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinationsHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.PassThroughThenCleanup;
import org.apache.beam.sdk.io.gcp.bigquery.PrepareWrite;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutation;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.RowWriterFactory;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinationsBeamRow;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinationsGenericRecord;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinationsProto;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinationsTableRow;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiLoads;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritesShardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.StreamingInserts;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowJsonCoder;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryIO {
    public static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_JOB_TEMPLATE = "beam_bq_job_{TYPE}_{JOB_ID}_{STEP}_{RANDOM}";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(BigQueryIO.class);
    static final @UnknownKeyFor @NonNull @Initialized JsonFactory JSON_FACTORY = Transport.getJsonFactory();
    private static final @UnknownKeyFor @NonNull @Initialized String PROJECT_ID_REGEXP = "[a-z][-a-z0-9:.]{0,61}[a-z0-9]";
    private static final @UnknownKeyFor @NonNull @Initialized String DATASET_REGEXP = "[-\\w.]{1,1024}";
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_REGEXP = "[-\\w$@ ]{1,1024}";
    private static final @UnknownKeyFor @NonNull @Initialized String DATASET_TABLE_REGEXP = String.format("((?<PROJECT>%s)[:\\.])?(?<DATASET>%s)\\.(?<TABLE>%s)", "[a-z][-a-z0-9:.]{0,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@ ]{1,1024}");
    static final @UnknownKeyFor @NonNull @Initialized Pattern TABLE_SPEC = Pattern.compile(DATASET_TABLE_REGEXP);
    private static final @UnknownKeyFor @NonNull @Initialized String TABLE_URN_REGEXP = String.format("projects/(?<PROJECT>%s)/datasets/(?<DATASET>%s)/tables/(?<TABLE>%s)", "[a-z][-a-z0-9:.]{0,61}[a-z0-9]", "[-\\w.]{1,1024}", "[-\\w$@ ]{1,1024}");
    static final @UnknownKeyFor @NonNull @Initialized Pattern TABLE_URN_SPEC = Pattern.compile(TABLE_URN_REGEXP);
    static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableRow, @UnknownKeyFor @NonNull @Initialized TableRow> TABLE_ROW_IDENTITY_FORMATTER = SerializableFunctions.identity();
    static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<@UnknownKeyFor @NonNull @Initialized GenericRecord>, @UnknownKeyFor @NonNull @Initialized GenericRecord> GENERIC_RECORD_IDENTITY_FORMATTER = AvroWriteRequest::getElement;
    static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<@UnknownKeyFor @NonNull @Initialized GenericRecord>> GENERIC_DATUM_WRITER_FACTORY = (SerializableFunction & Serializable)schema -> new GenericDatumWriter();
    private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> DEFAULT_AVRO_SCHEMA_FACTORY = BigQueryAvroUtils::toGenericAvroSchema;
    static final @UnknownKeyFor @NonNull @Initialized String CONNECTION_ID = "connectionId";
    static final @UnknownKeyFor @NonNull @Initialized String STORAGE_URI = "storageUri";

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new Read();
    }

    public static @UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> readTableRows() {
        return BigQueryIO.read(new TableRowParser()).withCoder((Coder<TableRow>)TableRowJsonCoder.of());
    }

    public static @UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> readTableRowsWithSchema() {
        return BigQueryIO.read(new TableRowParser()).withCoder((Coder<TableRow>)TableRowJsonCoder.of()).withBeamRowConverters((TypeDescriptor<TableRow>)TypeDescriptor.of(TableRow.class), BigQueryUtils.tableRowToBeamRow(), BigQueryUtils.tableRowFromBeamRow());
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypedRead<T> read(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn) {
        return new AutoValue_BigQueryIO_TypedRead.Builder().setValidate(true).setWithTemplateCompatibility(false).setBigQueryServices(new BigQueryServicesImpl()).setDatumReaderFactory((SerializableFunction & Serializable)input -> {
            try {
                String jsonTableSchema = JSON_FACTORY.toString(input);
                return (AvroSource.DatumReaderFactory & Serializable)(writer, reader) -> new GenericDatumTransformer(parseFn, jsonTableSchema, writer);
            }
            catch (IOException e) {
                LOG.warn(String.format("Error while converting table schema %s to JSON!", input), (Throwable)e);
                return null;
            }
        }).setParseFn(parseFn).setMethod(TypedRead.Method.DEFAULT).setUseAvroLogicalTypes(false).setFormat(DataFormat.AVRO).setProjectionPushdownApplied(false).setBadRecordErrorHandler((ErrorHandler<BadRecord, ?>)new ErrorHandler.DefaultErrorHandler()).setBadRecordRouter(BadRecordRouter.THROWING_ROUTER).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized TypedRead<T> readWithDatumReader(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T> readerFactory) {
        return new AutoValue_BigQueryIO_TypedRead.Builder().setValidate(true).setWithTemplateCompatibility(false).setBigQueryServices(new BigQueryServicesImpl()).setDatumReaderFactory((SerializableFunction & Serializable)input -> readerFactory).setMethod(TypedRead.Method.DEFAULT).setUseAvroLogicalTypes(false).setFormat(DataFormat.AVRO).setProjectionPushdownApplied(false).setBadRecordErrorHandler((ErrorHandler<BadRecord, ?>)new ErrorHandler.DefaultErrorHandler()).setBadRecordRouter(BadRecordRouter.THROWING_ROUTER).build();
    }

    static @UnknownKeyFor @NonNull @Initialized String getExtractDestinationUri(@UnknownKeyFor @NonNull @Initialized String extractDestinationDir) {
        return String.format("%s/%s", extractDestinationDir, "*.avro");
    }

    static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResourceId> getExtractFilePaths(@UnknownKeyFor @NonNull @Initialized String extractDestinationDir, @UnknownKeyFor @NonNull @Initialized Job extractJob) throws @UnknownKeyFor @NonNull @Initialized IOException {
        JobStatistics jobStats = extractJob.getStatistics();
        List counts = jobStats.getExtract().getDestinationUriFileCounts();
        if (counts.size() != 1) {
            String errorMessage = counts.isEmpty() ? "No destination uri file count received." : String.format("More than one destination uri file count received. First two are %s, %s", counts.get(0), counts.get(1));
            throw new RuntimeException(errorMessage);
        }
        long filesCount = (Long)counts.get(0);
        ImmutableList.Builder paths = ImmutableList.builder();
        ResourceId extractDestinationDirResourceId = FileSystems.matchNewResource((String)extractDestinationDir, (boolean)true);
        for (long i = 0L; i < filesCount; ++i) {
            ResourceId filePath = extractDestinationDirResourceId.resolve(String.format("%012d%s", i, ".avro"), (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
            paths.add((Object)filePath);
        }
        return paths.build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_BigQueryIO_Write.Builder().setValidate(true).setBigQueryServices(new BigQueryServicesImpl()).setCreateDisposition(Write.CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(Write.WriteDisposition.WRITE_EMPTY).setSchemaUpdateOptions(Collections.emptySet()).setNumFileShards(0).setNumStorageWriteApiStreams(0).setMethod(Write.Method.DEFAULT).setExtendedErrorInfo(false).setSkipInvalidRows(false).setIgnoreUnknownValues(false).setIgnoreInsertIds(false).setUseAvroLogicalTypes(false).setMaxFilesPerPartition(10000).setMaxBytesPerPartition(0xB0000000000L).setOptimizeWrites(false).setUseBeamSchema(false).setAutoSharding(false).setPropagateSuccessful(true).setAutoSchemaUpdate(false).setDeterministicRecordIdFn(null).setMaxRetryJobs(1000).setPropagateSuccessfulStorageApiWrites(false).setPropagateSuccessfulStorageApiWritesPredicate((Predicate<String>)Predicates.alwaysTrue()).setDirectWriteProtos(true).setDefaultMissingValueInterpretation(AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE).setBadRecordErrorHandler((ErrorHandler<BadRecord, ?>)new ErrorHandler.DefaultErrorHandler()).setBadRecordRouter(BadRecordRouter.THROWING_ROUTER).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized TableRow> writeTableRows() {
        return BigQueryIO.write().withFormatFunction(TABLE_ROW_IDENTITY_FORMATTER);
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized RowMutation> applyRowMutations() {
        return BigQueryIO.write().withFormatFunction(RowMutation::getTableRow).withRowMutationInformationFn(RowMutation::getMutationInformation);
    }

    public static @UnknownKeyFor @NonNull @Initialized Write<@UnknownKeyFor @NonNull @Initialized GenericRecord> writeGenericRecords() {
        return BigQueryIO.write().withAvroFormatFunction(GENERIC_RECORD_IDENTITY_FORMATTER);
    }

    public static <T extends Message> @UnknownKeyFor @NonNull @Initialized Write<T> writeProtos(@UnknownKeyFor @NonNull @Initialized Class<T> protoMessageClass) {
        if (DynamicMessage.class.equals(protoMessageClass)) {
            throw new IllegalArgumentException("DynamicMessage is not supported.");
        }
        return BigQueryIO.write().withFormatFunction((SerializableFunction & Serializable)m -> TableRowToStorageApiProto.tableRowFromMessage(m, false, (Predicate<String>)Predicates.alwaysTrue())).withWriteProtosClass(protoMessageClass);
    }

    @VisibleForTesting
    static void clearStaticCaches() throws @UnknownKeyFor @NonNull @Initialized ExecutionException, @UnknownKeyFor @NonNull @Initialized InterruptedException {
        CreateTables.clearCreatedTables();
        TwoLevelMessageConverterCache.clear();
        StorageApiDynamicDestinationsTableRow.clearSchemaCache();
        StorageApiWriteUnshardedRecords.clearCache();
        StorageApiWritesShardedRecords.clearCache();
    }

    private BigQueryIO() {
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, WriteResult> {
        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTableRef();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> getTableFunction();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> getFormatFunction();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> getFormatRecordOnFailureFunction();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized RowWriterFactory.AvroRowWriterFactory<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getAvroRowWriterFactory();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> getAvroSchemaFactory();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getUseAvroLogicalTypes();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized DynamicDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getDynamicDestinations();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> getSchemaFromView();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonSchema();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTimePartitioning();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonClustering();

        abstract @UnknownKeyFor @NonNull @Initialized CreateDisposition getCreateDisposition();

        abstract @UnknownKeyFor @NonNull @Initialized WriteDisposition getWriteDisposition();

        abstract @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaUpdateOption> getSchemaUpdateOptions();

        abstract @Nullable @UnknownKeyFor @Initialized String getTableDescription();

        abstract @Nullable @UnknownKeyFor @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getBigLakeConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

        abstract @UnknownKeyFor @NonNull @Initialized BigQueryServices getBigQueryServices();

        abstract @Nullable @UnknownKeyFor @Initialized Integer getMaxFilesPerBundle();

        abstract @Nullable @UnknownKeyFor @Initialized Long getMaxFileSize();

        abstract @UnknownKeyFor @NonNull @Initialized int getNumFileShards();

        abstract @UnknownKeyFor @NonNull @Initialized int getNumStorageWriteApiStreams();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getPropagateSuccessfulStorageApiWrites();

        abstract @UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> getPropagateSuccessfulStorageApiWritesPredicate();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxFilesPerPartition();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxBytesPerPartition();

        abstract @Nullable @UnknownKeyFor @Initialized Duration getTriggeringFrequency();

        public abstract @UnknownKeyFor @NonNull @Initialized Method getMethod();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getLoadJobProjectId();

        abstract @Nullable @UnknownKeyFor @Initialized InsertRetryPolicy getFailedInsertRetryPolicy();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getCustomGcsTempLocation();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getExtendedErrorInfo();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getSkipInvalidRows();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getIgnoreUnknownValues();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getIgnoreInsertIds();

        abstract @UnknownKeyFor @NonNull @Initialized int getMaxRetryJobs();

        abstract @Nullable @UnknownKeyFor @Initialized String getKmsKey();

        abstract @Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getPrimaryKey();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized AppendRowsRequest.MissingValueInterpretation getDefaultMissingValueInterpretation();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getOptimizeWrites();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getUseBeamSchema();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getAutoSharding();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getPropagateSuccessful();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getAutoSchemaUpdate();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getWriteProtosClass();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getDirectWriteProtos();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> getDeterministicRecordIdFn();

        abstract @Nullable @UnknownKeyFor @Initialized String getWriteTempDataset();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> getRowMutationInformationFn();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getBadRecordErrorHandler();

        abstract @UnknownKeyFor @NonNull @Initialized BadRecordRouter getBadRecordRouter();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized TableReference table) {
            return this.to((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((tableSpec != null ? 1 : 0) != 0, (Object)"tableSpec can not be null");
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> tableFunction) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((tableFunction != null ? 1 : 0) != 0, (Object)"tableFunction can not be null");
            return this.toBuilder().setTableFunction(tableFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> dynamicDestinations) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((dynamicDestinations != null ? 1 : 0) != 0, (Object)"dynamicDestinations can not be null");
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFormatFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFormatRecordOnFailureFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> formatFunction) {
            return this.toBuilder().setFormatRecordOnFailureFunction(formatFunction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAvroFormatFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, @UnknownKeyFor @NonNull @Initialized GenericRecord> avroFormatFunction) {
            return this.withAvroWriter(avroFormatFunction, GENERIC_DATUM_WRITER_FACTORY);
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAvroWriter(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<T>> writerFactory) {
            return this.withAvroWriter(AvroWriteRequest::getElement, writerFactory);
        }

        public <AvroT> @UnknownKeyFor @NonNull @Initialized Write<T> withAvroWriter(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, AvroT> avroFormatFunction, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema, @UnknownKeyFor @NonNull @Initialized DatumWriter<AvroT>> writerFactory) {
            return this.toBuilder().setOptimizeWrites(true).setAvroRowWriterFactory(RowWriterFactory.avroRecords(avroFormatFunction, writerFactory)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAvroSchemaFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> avroSchemaFactory) {
            return this.toBuilder().setAvroSchemaFactory(avroSchemaFactory).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchema(@UnknownKeyFor @NonNull @Initialized TableSchema schema) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(schema)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableSchema> schema) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (Object)"schema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.NestedValueProvider.of(schema, (SerializableFunction)new BigQueryHelpers.TableSchemaToJsonSchema()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonSchema(@UnknownKeyFor @NonNull @Initialized String jsonSchema) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return this.withJsonSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)jsonSchema));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonSchema) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((jsonSchema != null ? 1 : 0) != 0, (Object)"jsonSchema can not be null");
            return this.toBuilder().setJsonSchema(jsonSchema).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchemaFromView(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> view) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((view != null ? 1 : 0) != 0, (Object)"view can not be null");
            return this.toBuilder().setSchemaFromView(view).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTimePartitioning(@UnknownKeyFor @NonNull @Initialized TimePartitioning partitioning) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.withJsonTimePartitioning((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(partitioning)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTimePartitioning(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TimePartitioning> partitioning) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.withJsonTimePartitioning((ValueProvider<String>)ValueProvider.NestedValueProvider.of(partitioning, (SerializableFunction)new BigQueryHelpers.TimePartitioningToJson()));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonTimePartitioning(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> partitioning) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((partitioning != null ? 1 : 0) != 0, (Object)"partitioning can not be null");
            return this.toBuilder().setJsonTimePartitioning(partitioning).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClustering(@UnknownKeyFor @NonNull @Initialized Clustering clustering) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((clustering != null ? 1 : 0) != 0, (Object)"clustering cannot be null");
            return this.withJsonClustering((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(clustering)));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withJsonClustering(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> jsonClustering) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((jsonClustering != null ? 1 : 0) != 0, (Object)"clustering cannot be null");
            return this.toBuilder().setJsonClustering(jsonClustering).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withClustering() {
            return this.withClustering(new Clustering());
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCreateDisposition(@UnknownKeyFor @NonNull @Initialized CreateDisposition createDisposition) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((createDisposition != null ? 1 : 0) != 0, (Object)"createDisposition can not be null");
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteDisposition(@UnknownKeyFor @NonNull @Initialized WriteDisposition writeDisposition) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((writeDisposition != null ? 1 : 0) != 0, (Object)"writeDisposition can not be null");
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSchemaUpdateOptions(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaUpdateOption> schemaUpdateOptions) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((schemaUpdateOptions != null ? 1 : 0) != 0, (Object)"schemaUpdateOptions can not be null");
            return this.toBuilder().setSchemaUpdateOptions(schemaUpdateOptions).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTableDescription(@UnknownKeyFor @NonNull @Initialized String tableDescription) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((tableDescription != null ? 1 : 0) != 0, (Object)"tableDescription can not be null");
            return this.toBuilder().setTableDescription(tableDescription).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withBigLakeConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> bigLakeConfiguration) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((bigLakeConfiguration != null ? 1 : 0) != 0, (Object)"bigLakeConfiguration can not be null");
            return this.toBuilder().setBigLakeConfiguration(bigLakeConfiguration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withFailedInsertRetryPolicy(@UnknownKeyFor @NonNull @Initialized InsertRetryPolicy retryPolicy) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((retryPolicy != null ? 1 : 0) != 0, (Object)"retryPolicy can not be null");
            return this.toBuilder().setFailedInsertRetryPolicy(retryPolicy).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((method != null ? 1 : 0) != 0, (Object)"method can not be null");
            return this.toBuilder().setMethod(method).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRowMutationInformationFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> updateFn) {
            return this.toBuilder().setRowMutationInformationFn(updateFn).build();
        }

        @UnknownKeyFor @NonNull @Initialized Write<T> withWriteProtosClass(@UnknownKeyFor @NonNull @Initialized Class<T> clazz) {
            return this.toBuilder().setWriteProtosClass(clazz).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDirectWriteProtos(@UnknownKeyFor @NonNull @Initialized boolean directWriteProtos) {
            return this.toBuilder().setDirectWriteProtos(directWriteProtos).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLoadJobProjectId(@UnknownKeyFor @NonNull @Initialized String loadJobProjectId) {
            return this.withLoadJobProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)loadJobProjectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withLoadJobProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> loadJobProjectId) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((loadJobProjectId != null ? 1 : 0) != 0, (Object)"loadJobProjectId can not be null");
            return this.toBuilder().setLoadJobProjectId(loadJobProjectId).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withTriggeringFrequency(@UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((triggeringFrequency != null ? 1 : 0) != 0, (Object)"triggeringFrequency can not be null");
            return this.toBuilder().setTriggeringFrequency(triggeringFrequency).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withNumFileShards(@UnknownKeyFor @NonNull @Initialized int numFileShards) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((numFileShards > 0 ? 1 : 0) != 0, (String)"numFileShards must be > 0, but was: %s", (int)numFileShards);
            return this.toBuilder().setNumFileShards(numFileShards).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withNumStorageWriteApiStreams(@UnknownKeyFor @NonNull @Initialized int numStorageWriteApiStreams) {
            return this.toBuilder().setNumStorageWriteApiStreams(numStorageWriteApiStreams).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPropagateSuccessfulStorageApiWrites(@UnknownKeyFor @NonNull @Initialized boolean propagateSuccessfulStorageApiWrites) {
            return this.toBuilder().setPropagateSuccessfulStorageApiWrites(propagateSuccessfulStorageApiWrites).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPropagateSuccessfulStorageApiWrites(@UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> columnsToPropagate) {
            return this.toBuilder().setPropagateSuccessfulStorageApiWrites(true).setPropagateSuccessfulStorageApiWritesPredicate(columnsToPropagate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCustomGcsTempLocation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> customGcsTempLocation) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((customGcsTempLocation != null ? 1 : 0) != 0, (Object)"customGcsTempLocation can not be null");
            return this.toBuilder().setCustomGcsTempLocation(customGcsTempLocation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withExtendedErrorInfo() {
            return this.toBuilder().setExtendedErrorInfo(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> skipInvalidRows() {
            return this.toBuilder().setSkipInvalidRows(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> ignoreUnknownValues() {
            return this.toBuilder().setIgnoreUnknownValues(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> useAvroLogicalTypes() {
            return this.toBuilder().setUseAvroLogicalTypes(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> ignoreInsertIds() {
            return this.toBuilder().setIgnoreInsertIds(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
            return this.toBuilder().setKmsKey(kmsKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withPrimaryKey(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> primaryKey) {
            return this.toBuilder().setPrimaryKey(primaryKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDefaultMissingValueInterpretation(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized AppendRowsRequest.MissingValueInterpretation missingValueInterpretation) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((missingValueInterpretation == AppendRowsRequest.MissingValueInterpretation.DEFAULT_VALUE || missingValueInterpretation == AppendRowsRequest.MissingValueInterpretation.NULL_VALUE ? 1 : 0) != 0);
            return this.toBuilder().setDefaultMissingValueInterpretation(missingValueInterpretation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> optimizedWrites() {
            return this.toBuilder().setOptimizeWrites(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> useBeamSchema() {
            return this.toBuilder().setUseBeamSchema(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAutoSharding() {
            return this.toBuilder().setAutoSharding(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxRetryJobs(@UnknownKeyFor @NonNull @Initialized int maxRetryJobs) {
            return this.toBuilder().setMaxRetryJobs(maxRetryJobs).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withSuccessfulInsertsPropagation(@UnknownKeyFor @NonNull @Initialized boolean propagateSuccessful) {
            return this.toBuilder().setPropagateSuccessful(propagateSuccessful).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withAutoSchemaUpdate(@UnknownKeyFor @NonNull @Initialized boolean autoSchemaUpdate) {
            return this.toBuilder().setAutoSchemaUpdate(autoSchemaUpdate).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withDeterministicRecordIdFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> toUniqueIdFunction) {
            return this.toBuilder().setDeterministicRecordIdFn(toUniqueIdFunction).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized Write<T> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testServices) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((testServices != null ? 1 : 0) != 0, (Object)"testServices can not be null");
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxFilesPerBundle(@UnknownKeyFor @NonNull @Initialized int maxFilesPerBundle) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((maxFilesPerBundle > 0 ? 1 : 0) != 0, (String)"maxFilesPerBundle must be > 0, but was: %s", (int)maxFilesPerBundle);
            return this.toBuilder().setMaxFilesPerBundle(maxFilesPerBundle).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxFileSize(@UnknownKeyFor @NonNull @Initialized long maxFileSize) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((maxFileSize > 0L ? 1 : 0) != 0, (String)"maxFileSize must be > 0, but was: %s", (long)maxFileSize);
            return this.toBuilder().setMaxFileSize(maxFileSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxFilesPerPartition(@UnknownKeyFor @NonNull @Initialized int maxFilesPerPartition) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((maxFilesPerPartition > 0 ? 1 : 0) != 0, (String)"maxFilesPerPartition must be > 0, but was: %s", (int)maxFilesPerPartition);
            return this.toBuilder().setMaxFilesPerPartition(maxFilesPerPartition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withMaxBytesPerPartition(@UnknownKeyFor @NonNull @Initialized long maxBytesPerPartition) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((maxBytesPerPartition > 0L ? 1 : 0) != 0, (String)"maxBytesPerPartition must be > 0, but was: %s", (long)maxBytesPerPartition);
            return this.toBuilder().setMaxBytesPerPartition(maxBytesPerPartition).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withWriteTempDataset(@UnknownKeyFor @NonNull @Initialized String writeTempDataset) {
            return this.toBuilder().setWriteTempDataset(writeTempDataset).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withErrorHandler(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> errorHandler) {
            return this.toBuilder().setBadRecordErrorHandler(errorHandler).setBadRecordRouter(BadRecordRouter.RECORDING_ROUTER).build();
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
            BigQueryOptions options = (BigQueryOptions)pipelineOptions.as(BigQueryOptions.class);
            if (this.getJsonTableRef() != null && this.getJsonTableRef().isAccessible() && this.getValidate()) {
                TableReference table = (TableReference)this.getTableWithDefaultProject(options).get();
                try (BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);){
                    BigQueryHelpers.verifyDatasetPresence(datasetService, table);
                    if (this.getCreateDisposition() == CreateDisposition.CREATE_NEVER) {
                        BigQueryHelpers.verifyTablePresence(datasetService, table);
                    }
                    if (this.getWriteDisposition() == WriteDisposition.WRITE_EMPTY) {
                        BigQueryHelpers.verifyTableNotExistOrEmpty(datasetService, table);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Method resolveMethod(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (this.getMethod() != Method.DEFAULT) {
                return this.getMethod();
            }
            if (this.getRowMutationInformationFn() != null) {
                return Method.STORAGE_API_AT_LEAST_ONCE;
            }
            BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
            if (bqOptions.getUseStorageWriteApi().booleanValue()) {
                return bqOptions.getUseStorageWriteApiAtLeastOnce() != false ? Method.STORAGE_API_AT_LEAST_ONCE : Method.STORAGE_WRITE_API;
            }
            return input.isBounded() == PCollection.IsBounded.UNBOUNDED ? Method.STREAMING_INSERTS : Method.FILE_LOADS;
        }

        private @UnknownKeyFor @NonNull @Initialized Duration getStorageApiTriggeringFrequency(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) {
            if (this.getTriggeringFrequency() != null) {
                return this.getTriggeringFrequency();
            }
            if (options.getStorageWriteApiTriggeringFrequencySec() != null) {
                return Duration.standardSeconds((long)options.getStorageWriteApiTriggeringFrequencySec().intValue());
            }
            return null;
        }

        private @UnknownKeyFor @NonNull @Initialized int getStorageApiNumStreams(@UnknownKeyFor @NonNull @Initialized BigQueryOptions options) {
            if (this.getNumStorageWriteApiStreams() != 0) {
                return this.getNumStorageWriteApiStreams();
            }
            return options.getNumStorageWriteApiStreams();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            DynamicDestinations<T, ?> dynamicDestinations;
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getTableFunction() != null || this.getJsonTableRef() != null || this.getDynamicDestinations() != null ? 1 : 0) != 0, (Object)"must set the table reference of a BigQueryIO.Write transform");
            ArrayList allToArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonTableRef(), this.getTableFunction(), this.getDynamicDestinations()});
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((1 == Iterables.size((Iterable)allToArgs.stream().filter(arg_0 -> ((org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"Exactly one of jsonTableRef, tableFunction, or dynamicDestinations must be set");
            ArrayList allSchemaArgs = Lists.newArrayList((Object[])new Serializable[]{this.getJsonSchema(), this.getSchemaFromView(), this.getDynamicDestinations()});
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((2 > Iterables.size((Iterable)allSchemaArgs.stream().filter(arg_0 -> ((org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate)Predicates.notNull()).apply(arg_0)).collect(Collectors.toList())) ? 1 : 0) != 0, (Object)"No more than one of jsonSchema, schemaFromView, or dynamicDestinations may be set");
            BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
            Method method = this.resolveMethod(input);
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                if (method == Method.FILE_LOADS || method == Method.STORAGE_WRITE_API) {
                    Duration triggeringFrequency = method == Method.STORAGE_WRITE_API ? this.getStorageApiTriggeringFrequency(bqOptions) : this.getTriggeringFrequency();
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((triggeringFrequency != null ? 1 : 0) != 0, (Object)"When writing an unbounded PCollection via FILE_LOADS or STORAGE_WRITE_API, triggering frequency must be specified");
                } else {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getTriggeringFrequency() == null ? 1 : 0) != 0, (String)"Triggering frequency can be specified only when writing via FILE_LOADS or STORAGE_WRITE_API, but the method was %s.", (Object)((Object)method));
                }
                if (method != Method.FILE_LOADS) {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getNumFileShards() == 0 ? 1 : 0) != 0, (String)"Number of file shards can be specified only when writing via FILE_LOADS, but the method was %s.", (Object)((Object)method));
                }
                if (method == Method.STORAGE_API_AT_LEAST_ONCE && this.getStorageApiTriggeringFrequency(bqOptions) != null) {
                    LOG.warn("Storage API triggering frequency option will be ignored is it can only be specified only when writing via STORAGE_WRITE_API, but the method was {}.", (Object)method);
                }
                if (this.getAutoSharding().booleanValue()) {
                    if (method == Method.STORAGE_WRITE_API && this.getStorageApiNumStreams(bqOptions) > 0) {
                        LOG.warn("Both numStorageWriteApiStreams and auto-sharding options are set. Will default to auto-sharding. To set a fixed number of streams, do not enable auto-sharding.");
                    } else if (method == Method.FILE_LOADS && this.getNumFileShards() > 0) {
                        LOG.warn("Both numFileShards and auto-sharding options are set. Will default to auto-sharding. To set a fixed number of file shards, do not enable auto-sharding.");
                    } else if (method == Method.STORAGE_API_AT_LEAST_ONCE) {
                        LOG.warn("The setting of auto-sharding is ignored. It is only supported when writing an unbounded PCollection via FILE_LOADS, STREAMING_INSERTS or STORAGE_WRITE_API, but the method was {}.", (Object)method);
                    }
                }
            } else {
                String error = String.format(" is only applicable to an unbounded PCollection, but the input PCollection is %s.", input.isBounded());
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getTriggeringFrequency() == null ? 1 : 0) != 0, (Object)("Triggering frequency" + error));
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getAutoSharding() == false ? 1 : 0) != 0, (Object)("Auto-sharding" + error));
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getNumFileShards() == 0 ? 1 : 0) != 0, (Object)("Number of file shards" + error));
                if (this.getStorageApiTriggeringFrequency(bqOptions) != null) {
                    LOG.warn("Setting a triggering frequency" + error);
                }
                if (this.getStorageApiNumStreams(bqOptions) != 0) {
                    LOG.warn("Setting the number of Storage API streams" + error);
                }
            }
            if (method == Method.STORAGE_API_AT_LEAST_ONCE && this.getStorageApiNumStreams(bqOptions) != 0) {
                LOG.warn("Setting a number of Storage API streams is only supported when using STORAGE_WRITE_API");
            }
            if (method != Method.STORAGE_WRITE_API && method != Method.STORAGE_API_AT_LEAST_ONCE) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getAutoSchemaUpdate() == false ? 1 : 0) != 0, (Object)"withAutoSchemaUpdate only supported when using STORAGE_WRITE_API or STORAGE_API_AT_LEAST_ONCE.");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getBigLakeConfiguration() == null ? 1 : 0) != 0, (Object)"bigLakeConfiguration is only supported when using STORAGE_WRITE_API or STORAGE_API_AT_LEAST_ONCE.");
            } else {
                if (this.getWriteDisposition() == WriteDisposition.WRITE_TRUNCATE) {
                    LOG.error("The Storage API sink does not support the WRITE_TRUNCATE write disposition.");
                }
                if (this.getBigLakeConfiguration() != null) {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)Arrays.stream(new String[]{BigQueryIO.CONNECTION_ID, BigQueryIO.STORAGE_URI}).allMatch(this.getBigLakeConfiguration()::containsKey), (Object)String.format("bigLakeConfiguration must contain keys '%s' and '%s'", BigQueryIO.CONNECTION_ID, BigQueryIO.STORAGE_URI));
                }
            }
            if (this.getRowMutationInformationFn() != null) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getMethod() == Method.STORAGE_API_AT_LEAST_ONCE ? 1 : 0) != 0, (Object)"When using row updates on BigQuery, StorageWrite API should execute using \"at least once\" mode.");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getCreateDisposition() == CreateDisposition.CREATE_NEVER || this.getPrimaryKey() != null ? 1 : 0) != 0, (Object)"If specifying CREATE_IF_NEEDED along with row updates, a primary key needs to be specified");
            }
            if (this.getPrimaryKey() != null) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getMethod() != Method.FILE_LOADS ? 1 : 0) != 0, (Object)"Primary key not supported when using FILE_LOADS");
            }
            if (this.getAutoSchemaUpdate().booleanValue()) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.getIgnoreUnknownValues(), (Object)"Auto schema update currently only supported when ignoreUnknownValues also set.");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getUseBeamSchema() == false ? 1 : 0) != 0, (Object)"Auto schema update not supported when using Beam schemas.");
            }
            if (this.getJsonTimePartitioning() != null) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getDynamicDestinations() == null ? 1 : 0) != 0, (Object)"The supplied DynamicDestinations object can directly set TimePartitioning. There is no need to call BigQueryIO.Write.withTimePartitioning.");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getTableFunction() == null ? 1 : 0) != 0, (Object)"The supplied getTableFunction object can directly set TimePartitioning. There is no need to call BigQueryIO.Write.withTimePartitioning.");
            }
            if ((dynamicDestinations = this.getDynamicDestinations()) == null) {
                if (this.getJsonTableRef() != null) {
                    dynamicDestinations = DynamicDestinationsHelpers.ConstantTableDestinations.fromJsonTableRef(this.getJsonTableRef(), this.getTableDescription(), this.getJsonClustering() != null);
                } else if (this.getTableFunction() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.TableFunctionDestinations<T>(this.getTableFunction(), this.getJsonClustering() != null);
                }
                if (this.getJsonSchema() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations(dynamicDestinations, this.getJsonSchema());
                } else if (this.getSchemaFromView() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.SchemaFromViewDestinations<T>(dynamicDestinations, this.getSchemaFromView());
                }
                if (this.getJsonTimePartitioning() != null || this.getJsonClustering() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantTimePartitioningClusteringDestinations<T>(dynamicDestinations, this.getJsonTimePartitioning(), this.getJsonClustering());
                }
                if (this.getPrimaryKey() != null) {
                    dynamicDestinations = new DynamicDestinationsHelpers.ConstantTableConstraintsDestinations(dynamicDestinations, new TableConstraints().setPrimaryKey(new TableConstraints.PrimaryKey().setColumns(this.getPrimaryKey())));
                }
            }
            return this.expandTyped(input, dynamicDestinations);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <DestinationT> @UnknownKeyFor @NonNull @Initialized WriteResult expandTyped(@UnknownKeyFor @NonNull @Initialized PCollection<T> input, @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> dynamicDestinations) {
            RowWriterFactory rowWriterFactory;
            Coder<DestinationT> destinationCoder;
            boolean optimizeWrites = this.getOptimizeWrites();
            SerializableFunction<T, TableRow> formatFunction = this.getFormatFunction();
            SerializableFunction<T, TableRow> formatRecordOnFailureFunction = this.getFormatRecordOnFailureFunction();
            RowWriterFactory.AvroRowWriterFactory<T, T, T> avroRowWriterFactory = this.getAvroRowWriterFactory();
            boolean hasSchema = this.getJsonSchema() != null || this.getDynamicDestinations() != null || this.getSchemaFromView() != null;
            Class<T> writeProtoClass = this.getWriteProtosClass();
            if (this.getUseBeamSchema().booleanValue()) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)input.hasSchema(), (Object)"The input doesn't has a schema");
                optimizeWrites = true;
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((avroRowWriterFactory == null ? 1 : 0) != 0, (Object)"avro avroFormatFunction is unsupported when using Beam schemas.");
                if (formatFunction == null) {
                    formatFunction = BigQueryUtils.toTableRow(input.getToRowFunction());
                }
                TableSchema tableSchema = BigQueryUtils.toTableSchema(input.getSchema());
                dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations<T, DestinationT>(dynamicDestinations, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableSchema)));
            } else if (writeProtoClass != null) {
                if (!hasSchema) {
                    try {
                        Descriptors.Descriptor descriptor = (Descriptors.Descriptor)((java.lang.reflect.Method)Preconditions.checkStateNotNull((Object)writeProtoClass.getMethod("getDescriptor", new Class[0]))).invoke(null, new Object[0]);
                        TableSchema tableSchema = TableRowToStorageApiProto.protoSchemaToTableSchema(TableRowToStorageApiProto.tableSchemaFromDescriptor(descriptor));
                        dynamicDestinations = new DynamicDestinationsHelpers.ConstantSchemaDestinations<T, DestinationT>(dynamicDestinations, (ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableSchema)));
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            } else {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getCreateDisposition() != CreateDisposition.CREATE_IF_NEEDED || hasSchema ? 1 : 0) != 0, (Object)"CreateDisposition is CREATE_IF_NEEDED, however no schema was provided.");
            }
            try {
                destinationCoder = dynamicDestinations.getDestinationCoderWithDefault(input.getPipeline().getCoderRegistry());
            }
            catch (CannotProvideCoderException e) {
                throw new RuntimeException(e);
            }
            Method method = this.resolveMethod(input);
            if (optimizeWrites) {
                if (avroRowWriterFactory != null) {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((formatFunction == null ? 1 : 0) != 0, (Object)"Only one of withFormatFunction or withAvroFormatFunction/withAvroWriter maybe set, not both.");
                    @Nullable SerializableFunction avroSchemaFactory = this.getAvroSchemaFactory();
                    if (avroSchemaFactory == null) {
                        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)hasSchema, (Object)"A schema must be provided if an avroFormatFunction is set but no avroSchemaFactory is defined.");
                        avroSchemaFactory = DEFAULT_AVRO_SCHEMA_FACTORY;
                    }
                    rowWriterFactory = avroRowWriterFactory.prepare(dynamicDestinations, avroSchemaFactory);
                } else {
                    if (formatFunction == null) throw new IllegalArgumentException("A function must be provided to convert the input type into a TableRow or GenericRecord. Use BigQueryIO.Write.withFormatFunction or BigQueryIO.Write.withAvroFormatFunction to provide a formatting function. A format function is not required if Beam schemas are used.");
                    rowWriterFactory = RowWriterFactory.tableRows(formatFunction, formatRecordOnFailureFunction);
                }
            } else {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((avroRowWriterFactory == null ? 1 : 0) != 0, (Object)"When using a formatFunction, the AvroRowWriterFactory should be null");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((formatFunction != null ? 1 : 0) != 0, (Object)"A function must be provided to convert the input type into a TableRow or GenericRecord. Use BigQueryIO.Write.withFormatFunction or BigQueryIO.Write.withAvroFormatFunction to provide a formatting function. A format function is not required if Beam schemas are used.");
                rowWriterFactory = RowWriterFactory.tableRows(formatFunction, formatRecordOnFailureFunction);
            }
            PCollection rowsWithDestination = ((PCollection)input.apply("PrepareWrite", new PrepareWrite(dynamicDestinations, SerializableFunctions.identity()))).setCoder((Coder)KvCoder.of(destinationCoder, (Coder)input.getCoder()));
            return this.continueExpandTyped(rowsWithDestination, input.getCoder(), this.getUseBeamSchema() != false ? input.getSchema() : null, this.getUseBeamSchema() != false ? input.getToRowFunction() : null, destinationCoder, dynamicDestinations, rowWriterFactory, method);
        }

        private <DestinationT> @UnknownKeyFor @NonNull @Initialized WriteResult continueExpandTyped(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, T>> input, @UnknownKeyFor @NonNull @Initialized Coder<T> elementCoder, @Nullable @UnknownKeyFor @Initialized Schema elementSchema, @Nullable @UnknownKeyFor @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> elementToRowFunction, @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder, @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> dynamicDestinations, @UnknownKeyFor @NonNull @Initialized RowWriterFactory<T, DestinationT> rowWriterFactory, @UnknownKeyFor @NonNull @Initialized Method method) {
            if (method == Method.STREAMING_INSERTS) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getWriteDisposition() != WriteDisposition.WRITE_TRUNCATE ? 1 : 0) != 0, (Object)"WriteDisposition.WRITE_TRUNCATE is not supported for an unbounded PCollection.");
                InsertRetryPolicy retryPolicy = (InsertRetryPolicy)MoreObjects.firstNonNull((Object)this.getFailedInsertRetryPolicy(), (Object)InsertRetryPolicy.alwaysRetry());
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.JsonTableRow ? 1 : 0) != 0, (Object)"Avro output is not supported when method == STREAMING_INSERTS");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getSchemaUpdateOptions() == null || this.getSchemaUpdateOptions().isEmpty() ? 1 : 0) != 0, (Object)"SchemaUpdateOptions are not supported when method == STREAMING_INSERTS");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!this.getPropagateSuccessfulStorageApiWrites() ? 1 : 0) != 0, (Object)"withPropagateSuccessfulStorageApiWrites only supported when using storage api writes.");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(this.getBadRecordRouter() instanceof BadRecordRouter.ThrowingBadRecordRouter), (Object)"Error Handling is not supported with STREAMING_INSERTS");
                RowWriterFactory.TableRowWriterFactory tableRowWriterFactory = (RowWriterFactory.TableRowWriterFactory)rowWriterFactory;
                StreamingInserts<DestinationT, T> streamingInserts = new StreamingInserts<DestinationT, T>(this.getCreateDisposition(), dynamicDestinations, elementCoder, tableRowWriterFactory.getToRowFn(), tableRowWriterFactory.getToFailsafeRowFn()).withInsertRetryPolicy(retryPolicy).withTestServices(this.getBigQueryServices()).withExtendedErrorInfo(this.getExtendedErrorInfo()).withSkipInvalidRows(this.getSkipInvalidRows()).withIgnoreUnknownValues(this.getIgnoreUnknownValues()).withIgnoreInsertIds(this.getIgnoreInsertIds()).withAutoSharding(this.getAutoSharding()).withSuccessfulInsertsPropagation(this.getPropagateSuccessful()).withDeterministicRecordIdFn(this.getDeterministicRecordIdFn()).withKmsKey(this.getKmsKey());
                return (WriteResult)input.apply(streamingInserts);
            }
            if (method == Method.FILE_LOADS) {
                JsonElement schema;
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getFailedInsertRetryPolicy() == null ? 1 : 0) != 0, (Object)"Record-insert retry policies are not supported when using BigQuery load jobs.");
                if (this.getUseAvroLogicalTypes()) {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.AvroGenericRecord ? 1 : 0) != 0, (Object)"useAvroLogicalTypes can only be set with Avro output.");
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!this.getPropagateSuccessfulStorageApiWrites() ? 1 : 0) != 0, (Object)"withPropagateSuccessfulStorageApiWrites only supported when using storage api writes.");
                if (!(this.getBadRecordRouter() instanceof BadRecordRouter.ThrowingBadRecordRouter)) {
                    LOG.warn("Error Handling is partially supported when using FILE_LOADS. Consider using STORAGE_WRITE_API or STORAGE_API_AT_LEAST_ONCE");
                }
                if (this.getJsonSchema() != null && this.getJsonSchema().isAccessible() && !(schema = JsonParser.parseString((String)((String)this.getJsonSchema().get()))).getAsJsonObject().keySet().isEmpty() && this.hasJsonTypeInSchema(schema)) {
                    if (rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.JsonTableRow) {
                        LOG.warn("Found JSON type in TableSchema for 'FILE_LOADS' write method. \nMake sure the TableRow value is a Jackson JsonNode to ensure the read as a JSON type. Otherwise it will read as a raw (escaped) string.\nSee https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-json#limitations for limitations.");
                    } else if (rowWriterFactory.getOutputType() == RowWriterFactory.OutputType.AvroGenericRecord) {
                        LOG.warn("Found JSON type in TableSchema for 'FILE_LOADS' write method. \n check steps in https://cloud.google.com/bigquery/docs/loading-data-cloud-storage-avro#extract_json_data_from_avro_data  to ensure the read as a JSON type. Otherwise it will read as a raw (escaped) string.");
                    }
                }
                BatchLoads<DestinationT, T> batchLoads = new BatchLoads<DestinationT, T>(this.getWriteDisposition(), this.getCreateDisposition(), this.getJsonTableRef() != null, dynamicDestinations, destinationCoder, this.getCustomGcsTempLocation(), this.getLoadJobProjectId(), this.getIgnoreUnknownValues(), elementCoder, rowWriterFactory, this.getKmsKey(), this.getJsonClustering() != null, this.getUseAvroLogicalTypes(), this.getWriteTempDataset(), this.getBadRecordRouter(), this.getBadRecordErrorHandler());
                batchLoads.setTestServices(this.getBigQueryServices());
                if (this.getSchemaUpdateOptions() != null) {
                    batchLoads.setSchemaUpdateOptions(this.getSchemaUpdateOptions());
                }
                if (this.getMaxFilesPerBundle() != null) {
                    batchLoads.setMaxNumWritersPerBundle(this.getMaxFilesPerBundle());
                }
                if (this.getMaxFileSize() != null) {
                    batchLoads.setMaxFileSize(this.getMaxFileSize());
                }
                batchLoads.setMaxFilesPerPartition(this.getMaxFilesPerPartition());
                batchLoads.setMaxBytesPerPartition(this.getMaxBytesPerPartition());
                if (PCollection.IsBounded.UNBOUNDED.equals((Object)input.isBounded())) {
                    batchLoads.setMaxRetryJobs(this.getMaxRetryJobs());
                }
                batchLoads.setTriggeringFrequency(this.getTriggeringFrequency());
                if (this.getAutoSharding().booleanValue()) {
                    batchLoads.setNumFileShards(0);
                } else {
                    batchLoads.setNumFileShards(this.getNumFileShards());
                }
                return (WriteResult)input.apply(batchLoads);
            }
            if (method == Method.STORAGE_WRITE_API || method == Method.STORAGE_API_AT_LEAST_ONCE) {
                StorageApiDynamicDestinations storageApiDynamicDestinations;
                BigQueryOptions bqOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
                if (this.getUseBeamSchema().booleanValue()) {
                    storageApiDynamicDestinations = new StorageApiDynamicDestinationsBeamRow<T, DestinationT>(dynamicDestinations, elementSchema, elementToRowFunction, this.getFormatRecordOnFailureFunction(), this.getRowMutationInformationFn() != null);
                } else if (this.getWriteProtosClass() != null && this.getDirectWriteProtos().booleanValue()) {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getRowMutationInformationFn() == null ? 1 : 0) != 0, (Object)"Row upserts and deletes are not for direct proto writes. Try setting withDirectWriteProtos(false)");
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getAutoSchemaUpdate() == false ? 1 : 0) != 0, (Object)"withAutoSchemaUpdate not supported when using writeProtos. Try setting withDirectWriteProtos(false)");
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getIgnoreUnknownValues() == false ? 1 : 0) != 0, (Object)"ignoreUnknownValues not supported when using writeProtos. Try setting withDirectWriteProtos(false)");
                    storageApiDynamicDestinations = new StorageApiDynamicDestinationsProto<T, DestinationT>(dynamicDestinations, this.getWriteProtosClass(), this.getFormatRecordOnFailureFunction());
                } else if (this.getAvroRowWriterFactory() != null) {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getJsonSchema() != null || this.getDynamicDestinations() != null || this.getSchemaFromView() != null ? 1 : 0) != 0, (Object)"A schema must be provided for avro rows to be used with StorageWrite API.");
                    RowWriterFactory.AvroRowWriterFactory recordWriterFactory = (RowWriterFactory.AvroRowWriterFactory)rowWriterFactory;
                    SerializableFunction<@Nullable TableSchema, org.apache.avro.Schema> avroSchemaFactory = Optional.ofNullable(this.getAvroSchemaFactory()).orElse((SerializableFunction<TableSchema, org.apache.avro.Schema>)DEFAULT_AVRO_SCHEMA_FACTORY);
                    storageApiDynamicDestinations = new StorageApiDynamicDestinationsGenericRecord<T, DestinationT>(dynamicDestinations, avroSchemaFactory, recordWriterFactory.getToAvroFn(), this.getFormatRecordOnFailureFunction(), this.getRowMutationInformationFn() != null);
                } else {
                    RowWriterFactory.TableRowWriterFactory tableRowWriterFactory = (RowWriterFactory.TableRowWriterFactory)rowWriterFactory;
                    storageApiDynamicDestinations = new StorageApiDynamicDestinationsTableRow<T, DestinationT>(dynamicDestinations, tableRowWriterFactory.getToRowFn(), this.getFormatRecordOnFailureFunction(), this.getRowMutationInformationFn() != null, this.getCreateDisposition(), this.getIgnoreUnknownValues(), this.getAutoSchemaUpdate());
                }
                int numShards = this.getStorageApiNumStreams(bqOptions);
                boolean enableAutoSharding = this.getAutoSharding();
                if (numShards == 0) {
                    enableAutoSharding = true;
                }
                StorageApiLoads<DestinationT, T> storageApiLoads = new StorageApiLoads<DestinationT, T>(destinationCoder, storageApiDynamicDestinations, this.getRowMutationInformationFn(), this.getCreateDisposition(), this.getKmsKey(), this.getStorageApiTriggeringFrequency(bqOptions), this.getBigQueryServices(), this.getStorageApiNumStreams(bqOptions), method == Method.STORAGE_API_AT_LEAST_ONCE, enableAutoSharding, this.getAutoSchemaUpdate(), this.getIgnoreUnknownValues(), this.getPropagateSuccessfulStorageApiWrites(), this.getPropagateSuccessfulStorageApiWritesPredicate(), this.getRowMutationInformationFn() != null, this.getDefaultMissingValueInterpretation(), this.getBigLakeConfiguration(), this.getBadRecordRouter(), this.getBadRecordErrorHandler());
                return (WriteResult)input.apply("StorageApiLoads", storageApiLoads);
            }
            throw new RuntimeException("Unexpected write method " + (Object)((Object)method));
        }

        private @UnknownKeyFor @NonNull @Initialized boolean hasJsonTypeInSchema(@UnknownKeyFor @NonNull @Initialized JsonElement schema) {
            JsonElement fields = schema.getAsJsonObject().get("fields");
            if (!fields.isJsonArray() || fields.getAsJsonArray().isEmpty()) {
                return false;
            }
            JsonArray fieldArray = fields.getAsJsonArray();
            for (int i = 0; i < fieldArray.size(); ++i) {
                JsonObject field = fieldArray.get(i).getAsJsonObject();
                if (field.get("type").getAsString().equals("JSON")) {
                    return true;
                }
                if (!field.get("type").getAsString().equals("STRUCT") || !this.hasJsonTypeInSchema((JsonElement)field)) continue;
                return true;
            }
            return false;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", this.getJsonTableRef()).withLabel("Table Reference"));
            if (this.getJsonSchema() != null) {
                builder.addIfNotNull(DisplayData.item((String)"schema", this.getJsonSchema()).withLabel("Table Schema"));
            } else {
                builder.add(DisplayData.item((String)"schema", (String)"Custom Schema Function").withLabel("Table Schema"));
            }
            if (this.getTableFunction() != null) {
                builder.add(DisplayData.item((String)"tableFn", this.getTableFunction().getClass()).withLabel("Table Reference Function"));
            }
            builder.add(DisplayData.item((String)"createDisposition", (String)this.getCreateDisposition().toString()).withLabel("Table CreateDisposition")).add(DisplayData.item((String)"writeDisposition", (String)this.getWriteDisposition().toString()).withLabel("Table WriteDisposition")).add(DisplayData.item((String)"schemaUpdateOptions", (String)this.getSchemaUpdateOptions().toString()).withLabel("Table SchemaUpdateOptions")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true).addIfNotNull(DisplayData.item((String)"tableDescription", (String)this.getTableDescription()).withLabel("Table Description"));
        }

        @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTableWithDefaultProject(@UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
            ValueProvider<TableReference> table = this.getTable();
            if (table == null) {
                return table;
            }
            if (!table.isAccessible()) {
                LOG.info("Using a dynamic value for table input. This must contain a project in the table reference: {}", table);
                return table;
            }
            if (Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                TableReference tableRef = (TableReference)table.get();
                tableRef.setProjectId(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject());
                return ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toJsonString(tableRef)), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
            }
            return table;
        }

        public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTable() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        public static enum SchemaUpdateOption {
            ALLOW_FIELD_ADDITION,
            ALLOW_FIELD_RELAXATION;

        }

        public static enum WriteDisposition {
            WRITE_TRUNCATE,
            WRITE_APPEND,
            WRITE_EMPTY;

        }

        public static enum CreateDisposition {
            CREATE_NEVER,
            CREATE_IF_NEEDED;

        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonTableRef(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTableFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized ValueInSingleWindow<T>, @UnknownKeyFor @NonNull @Initialized TableDestination> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFormatFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFormatRecordOnFailureFunction(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAvroRowWriterFactory(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized RowWriterFactory.AvroRowWriterFactory<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAvroSchemaFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseAvroLogicalTypes(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDynamicDestinations(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchemaFromView(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonSchema(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonTimePartitioning(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonClustering(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCreateDisposition(@UnknownKeyFor @NonNull @Initialized CreateDisposition var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteDisposition(@UnknownKeyFor @NonNull @Initialized WriteDisposition var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSchemaUpdateOptions(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized SchemaUpdateOption> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTableDescription(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBigLakeConfiguration(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxFilesPerBundle(@UnknownKeyFor @NonNull @Initialized Integer var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxFileSize(@UnknownKeyFor @NonNull @Initialized Long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNumFileShards(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setNumStorageWriteApiStreams(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPropagateSuccessfulStorageApiWrites(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPropagateSuccessfulStorageApiWritesPredicate(@UnknownKeyFor @NonNull @Initialized Predicate<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxFilesPerPartition(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxBytesPerPartition(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTriggeringFrequency(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMethod(@UnknownKeyFor @NonNull @Initialized Method var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setLoadJobProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFailedInsertRetryPolicy(@UnknownKeyFor @NonNull @Initialized InsertRetryPolicy var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCustomGcsTempLocation(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setExtendedErrorInfo(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSkipInvalidRows(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setIgnoreUnknownValues(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setIgnoreInsertIds(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKmsKey(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPrimaryKey(@Nullable @UnknownKeyFor @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDefaultMissingValueInterpretation(// Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized AppendRowsRequest.MissingValueInterpretation var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setOptimizeWrites(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseBeamSchema(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAutoSharding(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMaxRetryJobs(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setPropagateSuccessful(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setAutoSchemaUpdate(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteProtosClass(@Nullable @UnknownKeyFor @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDirectWriteProtos(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDeterministicRecordIdFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWriteTempDataset(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRowMutationInformationFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized RowMutationInformation> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBadRecordErrorHandler(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBadRecordRouter(@UnknownKeyFor @NonNull @Initialized BadRecordRouter var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }

        public static enum Method {
            DEFAULT,
            FILE_LOADS,
            STREAMING_INSERTS,
            STORAGE_WRITE_API,
            STORAGE_API_AT_LEAST_ONCE;

        }
    }

    @AutoValue
    public static abstract class TypedRead<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>>
    implements ProjectionProducer<PTransform<PBegin, PCollection<T>>> {
        private static final @UnknownKeyFor @NonNull @Initialized String QUERY_VALIDATION_FAILURE_ERROR = "Validation of query \"%1$s\" failed. If the query depends on an earlier stage of the pipeline, This validation can be disabled using #withoutValidation.";

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getJsonTableRef();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getValidate();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getFlattenResults();

        abstract @Nullable @UnknownKeyFor @Initialized Boolean getUseLegacySql();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getWithTemplateCompatibility();

        abstract @UnknownKeyFor @NonNull @Initialized BigQueryServices getBigQueryServices();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> getParseFn();

        abstract @Nullable @UnknownKeyFor @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> getDatumReaderFactory();

        abstract @Nullable @UnknownKeyFor @Initialized QueryPriority getQueryPriority();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueryLocation();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueryTempDataset();

        abstract @Nullable @UnknownKeyFor @Initialized String getQueryTempProject();

        public abstract @UnknownKeyFor @NonNull @Initialized Method getMethod();

        abstract @UnknownKeyFor @NonNull @Initialized DataFormat getFormat();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> getSelectedFields();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getRowRestriction();

        abstract @Nullable @UnknownKeyFor @Initialized Coder<T> getCoder();

        abstract @Nullable @UnknownKeyFor @Initialized String getKmsKey();

        abstract @Nullable @UnknownKeyFor @Initialized TypeDescriptor<T> getTypeDescriptor();

        abstract @Nullable @UnknownKeyFor @Initialized ToBeamRowFunction<T> getToBeamRowFn();

        abstract @Nullable @UnknownKeyFor @Initialized FromBeamRowFunction<T> getFromBeamRowFn();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getUseAvroLogicalTypes();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> getBadRecordErrorHandler();

        abstract @UnknownKeyFor @NonNull @Initialized BadRecordRouter getBadRecordRouter();

        abstract @UnknownKeyFor @NonNull @Initialized boolean getProjectionPushdownApplied();

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Coder<T> inferCoder(@UnknownKeyFor @NonNull @Initialized CoderRegistry coderRegistry) {
            if (this.getCoder() != null) {
                return this.getCoder();
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(this.getParseFn()));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using withCoder().", e);
            }
        }

        private @UnknownKeyFor @NonNull @Initialized BigQuerySourceDef createSourceDef() {
            BigQuerySourceDef sourceDef = this.getQuery() == null ? BigQueryTableSourceDef.create(this.getBigQueryServices(), this.getTableProvider()) : BigQueryQuerySourceDef.create(this.getBigQueryServices(), this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), (QueryPriority)((Object)MoreObjects.firstNonNull((Object)((Object)this.getQueryPriority()), (Object)((Object)QueryPriority.BATCH))), this.getQueryLocation(), this.getQueryTempDataset(), this.getQueryTempProject(), this.getKmsKey());
            return sourceDef;
        }

        private @UnknownKeyFor @NonNull @Initialized BigQueryStorageQuerySource<T> createStorageQuerySource(@UnknownKeyFor @NonNull @Initialized String stepUuid, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder) {
            return BigQueryStorageQuerySource.create(stepUuid, this.getQuery(), this.getFlattenResults(), this.getUseLegacySql(), (QueryPriority)((Object)MoreObjects.firstNonNull((Object)((Object)this.getQueryPriority()), (Object)((Object)QueryPriority.BATCH))), this.getQueryLocation(), this.getQueryTempDataset(), this.getQueryTempProject(), this.getKmsKey(), this.getFormat(), this.getParseFn(), outputCoder, this.getBigQueryServices());
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            block19: {
                BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                if (this.getMethod() != Method.DIRECT_READ) {
                    String tempLocation = bqOptions.getTempLocation();
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tempLocation) ? 1 : 0) != 0, (Object)"BigQueryIO.Read needs a GCS temp location to store temp files.This can be set with option --tempLocation.");
                    if (this.getBigQueryServices() == null) {
                        try {
                            GcsPath.fromUri((String)tempLocation);
                        }
                        catch (IllegalArgumentException e) {
                            throw new IllegalArgumentException(String.format("BigQuery temp location expected a valid 'gs://' path, but was given '%s'", tempLocation), e);
                        }
                    }
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.getBadRecordRouter().equals(BadRecordRouter.THROWING_ROUTER), (Object)"BigQueryIO Read with Error Handling is only available when DIRECT_READ is used");
                }
                ValueProvider<TableReference> table = this.getTableProvider();
                if (this.getValidate()) {
                    try (BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(bqOptions);){
                        if (table != null) {
                            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)table.isAccessible(), (Object)"Cannot call validate if table is dynamically set.");
                        }
                        if (table != null && ((TableReference)table.get()).getProjectId() != null) {
                            BigQueryHelpers.verifyDatasetPresence(datasetService, (TableReference)table.get());
                            BigQueryHelpers.verifyTablePresence(datasetService, (TableReference)table.get());
                            break block19;
                        }
                        if (this.getQuery() == null) break block19;
                        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.getQuery().isAccessible(), (Object)"Cannot call validate if query is dynamically set.");
                        BigQueryServices.JobService jobService = this.getBigQueryServices().getJobService(bqOptions);
                        try {
                            jobService.dryRunQuery(bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject(), new JobConfigurationQuery().setQuery((String)this.getQuery().get()).setFlattenResults(this.getFlattenResults()).setUseLegacySql(this.getUseLegacySql()), this.getQueryLocation());
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format(QUERY_VALIDATION_FAILURE_ERROR, this.getQuery().get()), e);
                        }
                        if (this.getQueryTempDataset() != null) {
                            String project = this.getQueryTempProject();
                            if (project == null) {
                                project = bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject();
                            }
                            TableReference tempTable = new TableReference().setProjectId(project).setDatasetId(this.getQueryTempDataset()).setTableId("dummy table");
                            BigQueryHelpers.verifyDatasetPresence(datasetService, tempTable);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            PCollection rows;
            PCollectionView jobIdTokenView;
            ValueProvider<TableReference> table = this.getTableProvider();
            if (table != null) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getQuery() == null ? 1 : 0) != 0, (Object)"from() and fromQuery() are exclusive");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getQueryPriority() == null ? 1 : 0) != 0, (Object)"withQueryPriority() can only be specified when using fromQuery()");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getFlattenResults() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a result flattening preference, which only applies to queries");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getUseLegacySql() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a table with a SQL dialect preference, which only applies to queries");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getQueryTempDataset() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies a temp dataset, which can only be specified when using fromQuery()");
                if (table.isAccessible() && Strings.isNullOrEmpty((String)((TableReference)table.get()).getProjectId())) {
                    LOG.info("Project of {} not set. The value of {}.getProject() at execution time will be used.", (Object)TableReference.class.getSimpleName(), (Object)BigQueryOptions.class.getSimpleName());
                }
            } else {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getQuery() != null ? 1 : 0) != 0, (Object)"Either from() or fromQuery() is required");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getFlattenResults() != null ? 1 : 0) != 0, (Object)"flattenResults should not be null if query is set");
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getUseLegacySql() != null ? 1 : 0) != 0, (Object)"useLegacySql should not be null if query is set");
            }
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getDatumReaderFactory() != null ? 1 : 0) != 0, (Object)"A readerDatumFactory is required");
            Pipeline p = input.getPipeline();
            BigQueryOptions bqOptions = (BigQueryOptions)p.getOptions().as(BigQueryOptions.class);
            final BigQuerySourceDef sourceDef = this.createSourceDef();
            Schema beamSchema = null;
            if (this.getTypeDescriptor() != null && this.getToBeamRowFn() != null && this.getFromBeamRowFn() != null) {
                TableSchema tableSchema = sourceDef.getTableSchema(bqOptions);
                ValueProvider<List<String>> selectedFields = this.getSelectedFields();
                if (selectedFields != null && selectedFields.isAccessible()) {
                    tableSchema = BigQueryUtils.trimSchema(tableSchema, (List)selectedFields.get());
                }
                beamSchema = BigQueryUtils.fromTableSchema(tableSchema);
            }
            final Coder<T> coder = this.inferCoder(p.getCoderRegistry());
            if (this.getMethod() == Method.DIRECT_READ) {
                return this.expandForDirectRead(input, coder, beamSchema, bqOptions);
            }
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies selected fields, which only applies when using Method.DIRECT_READ");
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies row restriction, which only applies when using Method.DIRECT_READ");
            if (!this.getWithTemplateCompatibility().booleanValue()) {
                String staticJobUuid = BigQueryHelpers.randomUUIDString();
                jobIdTokenView = (PCollectionView)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)staticJobUuid, (Object[])new String[0]))).apply("ViewId", (PTransform)View.asSingleton());
                rows = (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(sourceDef.toSource(staticJobUuid, coder, this.getDatumReaderFactory(), this.getUseAvroLogicalTypes())));
            } else {
                PCollection jobIdTokenCollection = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                    public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized String input) {
                        return BigQueryHelpers.randomUUIDString();
                    }
                }));
                jobIdTokenView = (PCollectionView)jobIdTokenCollection.apply("ViewId", (PTransform)View.asSingleton());
                TupleTag filesTag = new TupleTag();
                final TupleTag tableSchemaTag = new TupleTag();
                PCollectionTuple tuple = (PCollectionTuple)jobIdTokenCollection.apply("RunCreateJob", (PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

                    @DoFn.ProcessElement
                    public void processElement(/*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        String jobUuid = (String)c.element();
                        BigQuerySourceBase source = sourceDef.toSource(jobUuid, coder, this.getDatumReaderFactory(), this.getUseAvroLogicalTypes());
                        BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                        BigQuerySourceBase.ExtractResult res = source.extractFiles(options);
                        LOG.info("Extract job produced {} files", (Object)res.extractedFiles.size());
                        source.cleanupTempResource(options);
                        for (ResourceId file : res.extractedFiles) {
                            c.output((Object)file.toString());
                        }
                        c.output(tableSchemaTag, (Object)BigQueryHelpers.toJsonString(res.schema));
                    }
                }).withOutputTags(filesTag, TupleTagList.of((TupleTag)tableSchemaTag)));
                tuple.get(filesTag).setCoder((Coder)StringUtf8Coder.of());
                tuple.get(tableSchemaTag).setCoder((Coder)StringUtf8Coder.of());
                final PCollectionView schemaView = (PCollectionView)tuple.get(tableSchemaTag).apply((PTransform)View.asSingleton());
                rows = ((PCollection)((PCollection)tuple.get(filesTag).apply((PTransform)Reshuffle.viaRandomKey())).apply("ReadFiles", (PTransform)ParDo.of((DoFn)new DoFn<String, T>(){

                    @DoFn.ProcessElement
                    public void processElement(/*
                     * Issues handling annotations - annotations may be inaccurate
                     */
                    // Could not load outer class - annotation placement on inner may be incorrect
                    @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                        TableSchema schema = BigQueryHelpers.fromJsonString((String)c.sideInput(schemaView), TableSchema.class);
                        String jobUuid = (String)c.sideInput(jobIdTokenView);
                        BigQuerySourceBase source = sourceDef.toSource(jobUuid, coder, this.getDatumReaderFactory(), this.getUseAvroLogicalTypes());
                        List sources = source.createSources((List<ResourceId>)ImmutableList.of((Object)FileSystems.matchNewResource((String)((String)c.element()), (boolean)false)), schema, null);
                        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((sources.size() == 1 ? 1 : 0) != 0, (Object)"Expected exactly one source.");
                        BoundedSource avroSource = sources.get(0);
                        BoundedSource.BoundedReader reader = avroSource.createReader(c.getPipelineOptions());
                        boolean more = reader.start();
                        while (more) {
                            c.output(reader.getCurrent());
                            more = reader.advance();
                        }
                    }
                }).withSideInputs(new PCollectionView[]{schemaView, jobIdTokenView}))).setCoder(coder);
            }
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(@UnknownKeyFor @NonNull @Initialized PassThroughThenCleanup.ContextContainer c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    List<ResourceId> extractFiles;
                    PipelineOptions options = c.getPipelineOptions();
                    BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
                    String jobUuid = c.getJobId();
                    String extractDestinationDir = BigQueryHelpers.resolveTempLocation(bqOptions.getTempLocation(), "BigQueryExtractTemp", jobUuid);
                    String executingProject = bqOptions.getBigQueryProject() == null ? bqOptions.getProject() : bqOptions.getBigQueryProject();
                    JobReference jobRef = new JobReference().setProjectId(executingProject).setJobId(BigQueryResourceNaming.createJobIdPrefix(bqOptions.getJobName(), jobUuid, BigQueryResourceNaming.JobType.EXPORT));
                    Job extractJob = this.getBigQueryServices().getJobService(bqOptions).getJob(jobRef);
                    if (extractJob != null && (extractFiles = BigQueryIO.getExtractFilePaths(extractDestinationDir, extractJob)) != null && !extractFiles.isEmpty()) {
                        FileSystems.delete(extractFiles, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
                    }
                }
            };
            rows = (PCollection)rows.apply(new PassThroughThenCleanup(cleanupOperation, (PCollectionView<String>)jobIdTokenView));
            if (beamSchema != null) {
                rows.setSchema(beamSchema, this.getTypeDescriptor(), (SerializableFunction)this.getToBeamRowFn().apply(beamSchema), (SerializableFunction)this.getFromBeamRowFn().apply(beamSchema));
            }
            return rows;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<T> expandForDirectRead(@UnknownKeyFor @NonNull @Initialized PBegin input, @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized Schema beamSchema, @UnknownKeyFor @NonNull @Initialized BigQueryOptions bqOptions) {
            PCollection<T> rows;
            PCollectionView jobIdTokenView;
            ValueProvider<TableReference> tableProvider = this.getTableProvider();
            Pipeline p = input.getPipeline();
            if (tableProvider != null) {
                List sources;
                if (this.getBadRecordRouter() instanceof BadRecordRouter.ThrowingBadRecordRouter) {
                    PCollection rows2 = (PCollection)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(BigQueryStorageTableSource.create(tableProvider, this.getFormat(), this.getSelectedFields(), this.getRowRestriction(), this.getParseFn(), outputCoder, this.getBigQueryServices(), this.getProjectionPushdownApplied())));
                    if (beamSchema != null) {
                        rows2.setSchema(beamSchema, this.getTypeDescriptor(), (SerializableFunction)this.getToBeamRowFn().apply(beamSchema), (SerializableFunction)this.getFromBeamRowFn().apply(beamSchema));
                    }
                    return rows2;
                }
                BigQueryStorageTableSource<T> source = BigQueryStorageTableSource.create(tableProvider, this.getFormat(), this.getSelectedFields(), this.getRowRestriction(), this.getParseFn(), outputCoder, this.getBigQueryServices(), this.getProjectionPushdownApplied());
                try {
                    long estimatedSize = source.getEstimatedSizeBytes(bqOptions);
                    long desiredChunkSize = estimatedSize <= 0L ? 0x4000000L : Math.max(0x100000L, (long)(1000.0 * Math.sqrt(estimatedSize)));
                    sources = source.split(desiredChunkSize, bqOptions);
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to split TableSource", e);
                }
                TupleTag rowTag = new TupleTag();
                PCollectionTuple resultTuple = (PCollectionTuple)((PCollection)p.apply((PTransform)Create.of((Iterable)sources))).apply("Read Storage Table Source", (PTransform)ParDo.of(new ReadTableSource<T>(rowTag, this.getParseFn(), this.getBadRecordRouter())).withOutputTags(rowTag, TupleTagList.of((TupleTag)BadRecordRouter.BAD_RECORD_TAG)));
                this.getBadRecordErrorHandler().addErrorCollection(resultTuple.get(BadRecordRouter.BAD_RECORD_TAG).setCoder(BadRecord.getCoder((Pipeline)input.getPipeline())));
                return resultTuple.get(rowTag).setCoder(outputCoder);
            }
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getSelectedFields() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies selected fields, which only applies when reading from a table");
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((this.getRowRestriction() == null ? 1 : 0) != 0, (Object)"Invalid BigQueryIO.Read: Specifies row restriction, which only applies when reading from a table");
            if (!this.getWithTemplateCompatibility().booleanValue() && this.getBadRecordRouter() instanceof BadRecordRouter.ThrowingBadRecordRouter) {
                String staticJobUuid = BigQueryHelpers.randomUUIDString();
                jobIdTokenView = (PCollectionView)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)staticJobUuid, (Object[])new String[0]))).apply("ViewId", (PTransform)View.asSingleton());
                rows = (PCollection<T>)p.apply((PTransform)org.apache.beam.sdk.io.Read.from(this.createStorageQuerySource(staticJobUuid, outputCoder)));
            } else {
                PCollection jobIdTokenCollection = (PCollection)((PCollection)p.apply("TriggerIdCreation", (PTransform)Create.of((Object)"ignored", (Object[])new String[0]))).apply("CreateJobId", (PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, String>(){

                    public @UnknownKeyFor @NonNull @Initialized String apply(@UnknownKeyFor @NonNull @Initialized String input) {
                        return BigQueryHelpers.randomUUIDString();
                    }
                }));
                jobIdTokenView = (PCollectionView)jobIdTokenCollection.apply("ViewId", (PTransform)View.asSingleton());
                TupleTag readStreamsTag = new TupleTag();
                TupleTag readSessionTag = new TupleTag();
                TupleTag tableSchemaTag = new TupleTag();
                PCollectionTuple tuple = this.createTupleForDirectRead((PCollection<String>)jobIdTokenCollection, outputCoder, (TupleTag<ReadStream>)readStreamsTag, (TupleTag<ReadSession>)readSessionTag, (TupleTag<String>)tableSchemaTag);
                tuple.get(readStreamsTag).setCoder((Coder)ProtoCoder.of(ReadStream.class));
                tuple.get(readSessionTag).setCoder((Coder)ProtoCoder.of(ReadSession.class));
                tuple.get(tableSchemaTag).setCoder((Coder)StringUtf8Coder.of());
                PCollectionView readSessionView = (PCollectionView)tuple.get(readSessionTag).apply("ReadSessionView", (PTransform)View.asSingleton());
                PCollectionView tableSchemaView = (PCollectionView)tuple.get(tableSchemaTag).apply("TableSchemaView", (PTransform)View.asSingleton());
                rows = this.createPCollectionForDirectRead(tuple, outputCoder, (TupleTag<ReadStream>)readStreamsTag, (PCollectionView<ReadSession>)readSessionView, (PCollectionView<String>)tableSchemaView);
            }
            PassThroughThenCleanup.CleanupOperation cleanupOperation = new PassThroughThenCleanup.CleanupOperation(){

                @Override
                void cleanup(@UnknownKeyFor @NonNull @Initialized PassThroughThenCleanup.ContextContainer c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                    String jobUuid = c.getJobId();
                    Optional<String> queryTempDataset = Optional.ofNullable(this.getQueryTempDataset());
                    String project = this.getQueryTempProject();
                    if (project == null) {
                        project = options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject();
                    }
                    TableReference tempTable = BigQueryResourceNaming.createTempTableReference(project, BigQueryResourceNaming.createJobIdPrefix(options.getJobName(), jobUuid, BigQueryResourceNaming.JobType.QUERY), queryTempDataset);
                    try (BigQueryServices.DatasetService datasetService = this.getBigQueryServices().getDatasetService(options);){
                        boolean datasetCreatedByBeam;
                        LOG.info("Deleting temporary table with query results {}", (Object)tempTable);
                        datasetService.deleteTable(tempTable);
                        boolean bl = datasetCreatedByBeam = !queryTempDataset.isPresent();
                        if (datasetCreatedByBeam) {
                            LOG.info("Deleting temporary dataset with query results {}", (Object)tempTable.getDatasetId());
                            datasetService.deleteDataset(tempTable.getProjectId(), tempTable.getDatasetId());
                        }
                    }
                }
            };
            if (beamSchema != null) {
                rows.setSchema(beamSchema, this.getTypeDescriptor(), (SerializableFunction)this.getToBeamRowFn().apply(beamSchema), (SerializableFunction)this.getFromBeamRowFn().apply(beamSchema));
            }
            return (PCollection)rows.apply(new PassThroughThenCleanup(cleanupOperation, (PCollectionView<String>)jobIdTokenView));
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionTuple createTupleForDirectRead(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> jobIdTokenCollection, final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ReadStream> readStreamsTag, final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ReadSession> readSessionTag, final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized String> tableSchemaTag) {
            PCollectionTuple tuple = (PCollectionTuple)jobIdTokenCollection.apply("RunQueryJob", (PTransform)ParDo.of((DoFn)new DoFn<String, ReadStream>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    ReadSession readSession;
                    BigQueryOptions options = (BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class);
                    String jobUuid = (String)c.element();
                    BigQueryStorageQuerySource querySource = this.createStorageQuerySource(jobUuid, outputCoder);
                    Table queryResultTable = querySource.getTargetTable(options);
                    CreateReadSessionRequest request = CreateReadSessionRequest.newBuilder().setParent(BigQueryHelpers.toProjectResourceName(options.getBigQueryProject() == null ? options.getProject() : options.getBigQueryProject())).setReadSession(ReadSession.newBuilder().setTable(BigQueryHelpers.toTableResourceName(queryResultTable.getTableReference())).setDataFormat(DataFormat.AVRO)).setMaxStreamCount(0).build();
                    try (BigQueryServices.StorageClient storageClient = this.getBigQueryServices().getStorageClient(options);){
                        readSession = storageClient.createReadSession(request);
                    }
                    for (ReadStream readStream : readSession.getStreamsList()) {
                        c.output((Object)readStream);
                    }
                    c.output(readSessionTag, (Object)readSession);
                    c.output(tableSchemaTag, (Object)BigQueryHelpers.toJsonString(queryResultTable.getSchema()));
                }
            }).withOutputTags(readStreamsTag, TupleTagList.of(readSessionTag).and(tableSchemaTag)));
            return tuple;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollection<T> createPCollectionForDirectRead(@UnknownKeyFor @NonNull @Initialized PCollectionTuple tuple, final @UnknownKeyFor @NonNull @Initialized Coder<T> outputCoder, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized ReadStream> readStreamsTag, final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized ReadSession> readSessionView, final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized String> tableSchemaView) {
            final TupleTag rowTag = new TupleTag();
            PCollectionTuple resultTuple = (PCollectionTuple)((PCollection)tuple.get(readStreamsTag).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)ParDo.of((DoFn)new DoFn<ReadStream, T>(){

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
                    ReadSession readSession = (ReadSession)c.sideInput(readSessionView);
                    TableSchema tableSchema = BigQueryHelpers.fromJsonString((String)c.sideInput(tableSchemaView), TableSchema.class);
                    ReadStream readStream = (ReadStream)c.element();
                    ErrorHandlingParseFn errorHandlingParseFn = new ErrorHandlingParseFn(this.getParseFn());
                    BigQueryStorageStreamSource streamSource = BigQueryStorageStreamSource.create(readSession, readStream, tableSchema, errorHandlingParseFn, outputCoder, this.getBigQueryServices());
                    TypedRead.readSource(c.getPipelineOptions(), rowTag, outputReceiver, streamSource, errorHandlingParseFn, this.getBadRecordRouter());
                }
            }).withSideInputs(new PCollectionView[]{readSessionView, tableSchemaView}).withOutputTags(rowTag, TupleTagList.of((TupleTag)BadRecordRouter.BAD_RECORD_TAG)));
            this.getBadRecordErrorHandler().addErrorCollection(resultTuple.get(BadRecordRouter.BAD_RECORD_TAG).setCoder(BadRecord.getCoder((Pipeline)tuple.getPipeline())));
            return resultTuple.get(rowTag).setCoder(outputCoder);
        }

        public static <T> void readSource(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized TupleTag<T> rowTag, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver, @UnknownKeyFor @NonNull @Initialized BoundedSource<T> streamSource, @UnknownKeyFor @NonNull @Initialized ErrorHandlingParseFn<T> errorHandlingParseFn, @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter) throws @UnknownKeyFor @NonNull @Initialized Exception {
            GenericRecord record;
            BoundedSource.BoundedReader reader = streamSource.createReader(options);
            try {
                if (!reader.start()) {
                    return;
                }
                outputReceiver.get(rowTag).output(reader.getCurrent());
            }
            catch (ParseException e) {
                record = errorHandlingParseFn.getSchemaAndRecord().getRecord();
                badRecordRouter.route(outputReceiver, (Object)record, (Coder)AvroCoder.of((org.apache.avro.Schema)record.getSchema()), (Exception)e.getCause(), "Unable to parse record reading from BigQuery");
            }
            while (true) {
                try {
                    while (reader.advance()) {
                        outputReceiver.get(rowTag).output(reader.getCurrent());
                    }
                    return;
                }
                catch (ParseException e) {
                    record = errorHandlingParseFn.getSchemaAndRecord().getRecord();
                    badRecordRouter.route(outputReceiver, (Object)record, (Coder)AvroCoder.of((org.apache.avro.Schema)record.getSchema()), (Exception)e.getCause(), "Unable to parse record reading from BigQuery");
                    continue;
                }
                break;
            }
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"table", BigQueryHelpers.displayTable(this.getTableProvider())).withLabel("Table")).addIfNotNull(DisplayData.item((String)"query", this.getQuery()).withLabel("Query")).addIfNotDefault(DisplayData.item((String)"projectionPushdownApplied", (Boolean)this.getProjectionPushdownApplied()).withLabel("Projection Pushdown Applied"), (Object)false).addIfNotNull(DisplayData.item((String)"flattenResults", (Boolean)this.getFlattenResults()).withLabel("Flatten Query Results")).addIfNotNull(DisplayData.item((String)"useLegacySql", (Boolean)this.getUseLegacySql()).withLabel("Use Legacy SQL Dialect")).addIfNotDefault(DisplayData.item((String)"validation", (Boolean)this.getValidate()).withLabel("Validation Enabled"), (Object)true);
            ValueProvider<List<String>> selectedFieldsProvider = this.getSelectedFields();
            if (selectedFieldsProvider != null && selectedFieldsProvider.isAccessible()) {
                builder.add(DisplayData.item((String)"selectedFields", (String)String.join((CharSequence)", ", (Iterable)selectedFieldsProvider.get())).withLabel("Selected Fields"));
            }
        }

        private void ensureFromNotCalledYet() {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((this.getJsonTableRef() == null && this.getQuery() == null ? 1 : 0) != 0, (Object)"from() or fromQuery() already called");
        }

        public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTableProvider() {
            return this.getJsonTableRef() == null ? null : ValueProvider.NestedValueProvider.of(this.getJsonTableRef(), (SerializableFunction)new BigQueryHelpers.JsonTableRefToTableRef());
        }

        public @Nullable @UnknownKeyFor @Initialized TableReference getTable() {
            ValueProvider<TableReference> provider = this.getTableProvider();
            return provider == null ? null : (TableReference)provider.get();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
            return this.toBuilder().setKmsKey(kmsKey).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withBeamRowConverters(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> typeDescriptor, @UnknownKeyFor @NonNull @Initialized ToBeamRowFunction<T> toRowFn, @UnknownKeyFor @NonNull @Initialized FromBeamRowFunction<T> fromRowFn) {
            return this.toBuilder().setTypeDescriptor(typeDescriptor).setToBeamRowFn(toRowFn).setFromBeamRowFn(fromRowFn).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> from(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setJsonTableRef((ValueProvider<String>)ValueProvider.NestedValueProvider.of((ValueProvider)ValueProvider.NestedValueProvider.of(tableSpec, (SerializableFunction)new BigQueryHelpers.TableSpecToTableRef()), (SerializableFunction)new BigQueryHelpers.TableRefToJson())).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> fromQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            return this.fromQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> fromQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            this.ensureFromNotCalledYet();
            return this.toBuilder().setQuery(query).setFlattenResults(true).setUseLegacySql(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> from(@UnknownKeyFor @NonNull @Initialized TableReference table) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)BigQueryHelpers.toTableSpec(table)));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withoutValidation() {
            return this.toBuilder().setValidate(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withoutResultFlattening() {
            return this.toBuilder().setFlattenResults(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> usingStandardSql() {
            return this.toBuilder().setUseLegacySql(false).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryPriority(@UnknownKeyFor @NonNull @Initialized QueryPriority priority) {
            return this.toBuilder().setQueryPriority(priority).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryLocation(@UnknownKeyFor @NonNull @Initialized String location) {
            return this.toBuilder().setQueryLocation(location).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryTempDataset(@UnknownKeyFor @NonNull @Initialized String queryTempDatasetRef) {
            return this.toBuilder().setQueryTempDataset(queryTempDatasetRef).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withQueryTempProjectAndDataset(@UnknownKeyFor @NonNull @Initialized String queryTempProjectRef, @UnknownKeyFor @NonNull @Initialized String queryTempDatasetRef) {
            return this.toBuilder().setQueryTempProject(queryTempProjectRef).setQueryTempDataset(queryTempDatasetRef).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withMethod(@UnknownKeyFor @NonNull @Initialized Method method) {
            return this.toBuilder().setMethod(method).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withFormat(@UnknownKeyFor @NonNull @Initialized DataFormat format) {
            return this.toBuilder().setFormat(format).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withSelectedFields(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> selectedFields) {
            return this.withSelectedFields((ValueProvider<List<String>>)ValueProvider.StaticValueProvider.of(selectedFields));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withSelectedFields(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> selectedFields) {
            return this.toBuilder().setSelectedFields(selectedFields).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withRowRestriction(@UnknownKeyFor @NonNull @Initialized String rowRestriction) {
            return this.withRowRestriction((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rowRestriction));
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withRowRestriction(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> rowRestriction) {
            return this.toBuilder().setRowRestriction(rowRestriction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withErrorHandler(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> badRecordErrorHandler) {
            return this.toBuilder().setBadRecordErrorHandler(badRecordErrorHandler).setBadRecordRouter(BadRecordRouter.RECORDING_ROUTER).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withTemplateCompatibility() {
            return this.toBuilder().setWithTemplateCompatibility(true).build();
        }

        @VisibleForTesting
        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testServices) {
            return this.toBuilder().setBigQueryServices(testServices).build();
        }

        public @UnknownKeyFor @NonNull @Initialized TypedRead<T> useAvroLogicalTypes() {
            return this.toBuilder().setUseAvroLogicalTypes(true).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized TypedRead<T> withProjectionPushdownApplied() {
            return this.toBuilder().setProjectionPushdownApplied(true).build();
        }

        public @UnknownKeyFor @NonNull @Initialized boolean supportsProjectionPushdown() {
            return Method.DIRECT_READ.equals((Object)this.getMethod()) && this.getQuery() == null;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<T>> actuateProjectionPushdown(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor> outputFields) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.supportsProjectionPushdown());
            FieldAccessDescriptor fieldAccessDescriptor = outputFields.get(new TupleTag("output"));
            Preconditions.checkArgumentNotNull((Object)fieldAccessDescriptor, (Object)"Expected pushdown on the main output (tagged 'output')");
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((outputFields.size() == 1 ? 1 : 0) != 0, (String)"Expected only to pushdown on the main output (tagged 'output'). Requested tags: %s", outputFields.keySet());
            ImmutableList fields = ImmutableList.copyOf((Collection)fieldAccessDescriptor.fieldNamesAccessed());
            return this.withSelectedFields((List<String>)fields).withProjectionPushdownApplied();
        }

        private static class ParseException
        extends RuntimeException {
            public ParseException(@UnknownKeyFor @NonNull @Initialized Exception e) {
                super(e);
            }
        }

        private static class ErrorHandlingParseFn<@UnknownKeyFor T>
        implements SerializableFunction<SchemaAndRecord, T> {
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
            private transient @UnknownKeyFor @NonNull @Initialized SchemaAndRecord schemaAndRecord = null;

            private ErrorHandlingParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn) {
                this.parseFn = parseFn;
            }

            public T apply(@UnknownKeyFor @NonNull @Initialized SchemaAndRecord input) {
                this.schemaAndRecord = input;
                try {
                    return (T)this.parseFn.apply((Object)input);
                }
                catch (Exception e) {
                    throw new ParseException(e);
                }
            }

            public @UnknownKeyFor @NonNull @Initialized SchemaAndRecord getSchemaAndRecord() {
                return this.schemaAndRecord;
            }
        }

        private static class ReadTableSource<@UnknownKeyFor T>
        extends DoFn<BoundedSource<T>, T> {
            private final @UnknownKeyFor @NonNull @Initialized TupleTag<T> rowTag;
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
            private final @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter;

            public ReadTableSource(@UnknownKeyFor @NonNull @Initialized TupleTag<T> rowTag, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized BadRecordRouter badRecordRouter) {
                this.rowTag = rowTag;
                this.parseFn = parseFn;
                this.badRecordRouter = badRecordRouter;
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized BoundedSource<T> boundedSource, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver outputReceiver, @UnknownKeyFor @NonNull @Initialized PipelineOptions options) throws @UnknownKeyFor @NonNull @Initialized Exception {
                ErrorHandlingParseFn errorHandlingParseFn = new ErrorHandlingParseFn(this.parseFn);
                if (!(boundedSource instanceof BigQueryStorageStreamSource)) {
                    throw new RuntimeException("Bounded Source is not BigQueryStorageStreamSource, unable to read");
                }
                BigQueryStorageStreamSource sourceWithErrorHandlingParseFn = ((BigQueryStorageStreamSource)boundedSource).fromExisting(errorHandlingParseFn);
                TypedRead.readSource(options, this.rowTag, outputReceiver, sourceWithErrorHandlingParseFn, errorHandlingParseFn, this.badRecordRouter);
            }
        }

        public static enum QueryPriority {
            INTERACTIVE,
            BATCH;

        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setJsonTableRef(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setValidate(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFlattenResults(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseLegacySql(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setWithTemplateCompatibility(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryPriority(@UnknownKeyFor @NonNull @Initialized QueryPriority var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryTempDataset(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setQueryTempProject(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMethod(@UnknownKeyFor @NonNull @Initialized Method var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFormat(@UnknownKeyFor @NonNull @Initialized DataFormat var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setSelectedFields(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRowRestriction(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized TypedRead<T> build();

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setParseFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setDatumReaderFactory(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized TableSchema, // Could not load outer class - annotation placement on inner may be incorrect
             @UnknownKeyFor @NonNull @Initialized AvroSource.DatumReaderFactory<T>> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCoder(@UnknownKeyFor @NonNull @Initialized Coder<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setKmsKey(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setTypeDescriptor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setToBeamRowFn(@UnknownKeyFor @NonNull @Initialized ToBeamRowFunction<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFromBeamRowFn(@UnknownKeyFor @NonNull @Initialized FromBeamRowFunction<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setUseAvroLogicalTypes(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBadRecordErrorHandler(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized ErrorHandler<@UnknownKeyFor @NonNull @Initialized BadRecord, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setBadRecordRouter(@UnknownKeyFor @NonNull @Initialized BadRecordRouter var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setProjectionPushdownApplied(@UnknownKeyFor @NonNull @Initialized boolean var1);
        }

        static interface FromBeamRowFunction<@UnknownKeyFor T>
        extends SerializableFunction<Schema, SerializableFunction<Row, T>> {
        }

        static interface ToBeamRowFunction<@UnknownKeyFor T>
        extends SerializableFunction<Schema, SerializableFunction<T, Row>> {
        }

        public static enum Method {
            DEFAULT,
            EXPORT,
            DIRECT_READ;

        }
    }

    public static class Read
    extends PTransform<PBegin, PCollection<TableRow>> {
        private final @UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> inner;

        Read() {
            this(BigQueryIO.read(TableRowParser.INSTANCE).withCoder((Coder<TableRow>)TableRowJsonCoder.of()));
        }

        Read(@UnknownKeyFor @NonNull @Initialized TypedRead<@UnknownKeyFor @NonNull @Initialized TableRow> inner) {
            this.inner = inner;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized TableRow> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return (PCollection)input.apply(this.inner);
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }

        @UnknownKeyFor @NonNull @Initialized boolean getValidate() {
            return this.inner.getValidate();
        }

        @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getQuery() {
            return this.inner.getQuery();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testServices) {
            return new Read(this.inner.withTestServices(testServices));
        }

        public @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized TableReference> getTableProvider() {
            return this.inner.getTableProvider();
        }

        public @Nullable @UnknownKeyFor @Initialized TableReference getTable() {
            return this.inner.getTable();
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized String tableSpec) {
            return new Read(this.inner.from(tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> tableSpec) {
            return new Read(this.inner.from(tableSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Read from(@UnknownKeyFor @NonNull @Initialized TableReference table) {
            return new Read(this.inner.from(table));
        }

        public @UnknownKeyFor @NonNull @Initialized Read fromQuery(@UnknownKeyFor @NonNull @Initialized String query) {
            return new Read(this.inner.fromQuery(query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read fromQuery(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> query) {
            return new Read(this.inner.fromQuery(query));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withoutValidation() {
            return new Read(this.inner.withoutValidation());
        }

        public @UnknownKeyFor @NonNull @Initialized Read withoutResultFlattening() {
            return new Read(this.inner.withoutResultFlattening());
        }

        public @UnknownKeyFor @NonNull @Initialized Read usingStandardSql() {
            return new Read(this.inner.usingStandardSql());
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTemplateCompatibility() {
            return new Read(this.inner.withTemplateCompatibility());
        }
    }

    @VisibleForTesting
    static class TableRowParser
    implements SerializableFunction<SchemaAndRecord, TableRow> {
        public static final @UnknownKeyFor @NonNull @Initialized TableRowParser INSTANCE = new TableRowParser();

        TableRowParser() {
        }

        public @UnknownKeyFor @NonNull @Initialized TableRow apply(@UnknownKeyFor @NonNull @Initialized SchemaAndRecord schemaAndRecord) {
            return BigQueryAvroUtils.convertGenericRecordToTableRow(schemaAndRecord.getRecord());
        }
    }

    @VisibleForTesting
    static class GenericDatumTransformer<@UnknownKeyFor T>
    implements DatumReader<T> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn;
        private final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized TableSchema> tableSchema;
        private @UnknownKeyFor @NonNull @Initialized GenericDatumReader<T> reader;
        private @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema writerSchema;

        public GenericDatumTransformer(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized SchemaAndRecord, T> parseFn, @UnknownKeyFor @NonNull @Initialized String tableSchema, @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema writer) {
            this.parseFn = parseFn;
            this.tableSchema = Suppliers.memoize((Supplier)Suppliers.compose((Function)new TableSchemaFunction(), (Supplier)Suppliers.ofInstance((Object)tableSchema)));
            this.writerSchema = writer;
            this.reader = new GenericDatumReader(this.writerSchema);
        }

        public void setSchema(@UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema schema) {
            if (this.writerSchema.equals((Object)schema)) {
                return;
            }
            this.writerSchema = schema;
            this.reader = new GenericDatumReader(this.writerSchema);
        }

        public T read(T reuse, @UnknownKeyFor @NonNull @Initialized Decoder in) throws @UnknownKeyFor @NonNull @Initialized IOException {
            GenericRecord record = (GenericRecord)this.reader.read(reuse, in);
            return (T)this.parseFn.apply((Object)new SchemaAndRecord(record, (TableSchema)this.tableSchema.get()));
        }
    }

    private static class TableSchemaFunction
    implements Serializable,
    Function<String, TableSchema> {
        private TableSchemaFunction() {
        }

        public @Nullable @UnknownKeyFor @Initialized TableSchema apply(@Nullable @UnknownKeyFor @Initialized String input) {
            return BigQueryHelpers.fromJsonString(input, TableSchema.class);
        }
    }
}

