/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro.jsr310.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.Function;

public class AvroInstantSerializer<T extends Temporal>
extends StdScalarSerializer<T> {
    private static final long serialVersionUID = 1L;
    public static final AvroInstantSerializer<Instant> INSTANT = new AvroInstantSerializer<Instant>(Instant.class, Function.identity());
    public static final AvroInstantSerializer<OffsetDateTime> OFFSET_DATE_TIME = new AvroInstantSerializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::toInstant);
    public static final AvroInstantSerializer<ZonedDateTime> ZONED_DATE_TIME = new AvroInstantSerializer<ZonedDateTime>(ZonedDateTime.class, ChronoZonedDateTime::toInstant);
    private final Function<T, Instant> getInstant;

    protected AvroInstantSerializer(Class<T> t, Function<T, Instant> getInstant) {
        super(t);
        this.getInstant = getInstant;
    }

    public void serialize(T value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        Instant instant = this.getInstant.apply(value);
        gen.writeNumber(instant.toEpochMilli());
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }
}

