/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.projects.config;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.projects.config.ProjectsConfig;
import org.apache.hop.projects.config.ProjectsConfigSingleton;
import org.apache.hop.projects.environment.LifecycleEnvironment;
import org.apache.hop.projects.project.Project;
import org.apache.hop.projects.project.ProjectConfig;
import org.apache.hop.projects.util.ProjectsUtil;
import picocli.CommandLine;

public class ProjectsOptionPlugin
implements IConfigOptions {
    @CommandLine.Option(names={"-e", "--environment"}, description={"The name of the lifecycle environment to use"})
    private String environmentOption = null;
    @CommandLine.Option(names={"-j", "--project"}, description={"The name of the project to use"})
    private String projectOption = null;
    protected String projectName;
    protected String environmentName;

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        this.projectName = this.projectOption;
        this.environmentName = this.environmentOption;
        return ProjectsOptionPlugin.configure(log, variables, hasHopMetadataProvider, this.projectName, this.environmentName);
    }

    public static final boolean configure(ILogChannel log, IVariables variables, IHasHopMetadataProvider hasHopMetadataProvider, String projectName, String environmentName) throws HopException {
        ProjectConfig projectConfig;
        ProjectsConfig config = ProjectsConfigSingleton.getConfig();
        ArrayList<String> configurationFiles = new ArrayList<String>();
        if (StringUtils.isEmpty((String)environmentName)) {
            environmentName = config.getDefaultEnvironment();
        }
        if (config.isEnvironmentMandatory() && StringUtils.isEmpty((String)environmentName)) {
            throw new HopException("Use of an environment is configured to be mandatory and none was specified.");
        }
        if (StringUtils.isEmpty((String)projectName)) {
            projectName = config.getDefaultProject();
        }
        if (config.isProjectMandatory() && StringUtils.isEmpty((String)projectName)) {
            throw new HopException("Use of a project is configured to be mandatory and none was specified.");
        }
        if (StringUtils.isNotEmpty((String)environmentName)) {
            LifecycleEnvironment environment = config.findEnvironment(environmentName);
            if (environment == null) {
                throw new HopException("Unable to find lifecycle environment '" + environmentName + "'");
            }
            projectName = environment.getProjectName();
            if (StringUtils.isEmpty((String)projectName)) {
                throw new HopException("Lifecycle environment '" + environmentName + "' is not referencing a project.");
            }
            projectConfig = config.findProjectConfig(projectName);
            if (projectConfig == null) {
                throw new HopException("Unable to find project '" + projectName + "' referenced in environment '" + environmentName);
            }
            configurationFiles.addAll(environment.getConfigurationFiles());
            log.logBasic("Referencing environment '" + environmentName + "' for project " + projectName + "' in " + environment.getPurpose());
        } else if (StringUtils.isNotEmpty((String)projectName)) {
            projectConfig = config.findProjectConfig(projectName);
            if (projectConfig == null) {
                throw new HopException("Unable to find project '" + projectName + "'");
            }
            projectName = projectConfig.getProjectName();
        } else {
            log.logDebug("No project or environment referenced.");
            return false;
        }
        try {
            Project project = projectConfig.loadProject(variables);
            log.logBasic("Enabling project '" + projectName + "'");
            if (project == null) {
                throw new HopException("Project '" + projectName + "' couldn't be found");
            }
            ProjectsUtil.enableProject(log, projectName, project, variables, configurationFiles, environmentName, hasHopMetadataProvider);
            return true;
        }
        catch (Exception e) {
            throw new HopException("Error enabling project '" + projectName + "'", (Throwable)e);
        }
    }
}

