/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropIndexNode
extends DDLStatementNode {
    private ConglomerateDescriptor cd;
    private TableDescriptor td;

    DropIndexNode(TableName tableName, ContextManager contextManager) {
        super(tableName, contextManager);
    }

    @Override
    String statementToString() {
        return "DROP INDEX";
    }

    @Override
    public void bindStatement() throws StandardException {
        ConstraintDescriptor constraintDescriptor;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        if (schemaDescriptor.getUUID() != null) {
            this.cd = dataDictionary.getConglomerateDescriptor(this.getRelativeName(), schemaDescriptor, false);
        }
        if (this.cd == null) {
            throw StandardException.newException((String)"42X65", (Object[])new Object[]{this.getFullName()});
        }
        this.td = this.getTableDescriptor(this.cd.getTableID());
        if (this.cd.isConstraint() && (constraintDescriptor = dataDictionary.getConstraintDescriptor(this.td, this.cd.getUUID())) != null) {
            String string = constraintDescriptor.getConstraintName();
            throw StandardException.newException((String)"42X84", (Object[])new Object[]{this.getFullName(), string});
        }
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(this.cd);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropIndexConstantAction(this.getFullName(), this.getRelativeName(), this.getRelativeName(), this.getSchemaDescriptor().getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
    }
}

