/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.ServerMessageMutator;
import org.apache.qpid.server.protocol.v0_8.AMQMessage;
import org.apache.qpid.server.protocol.v0_8.MessageMetaData;
import org.apache.qpid.server.protocol.v0_8.transport.BasicContentHeaderProperties;
import org.apache.qpid.server.protocol.v0_8.transport.ContentHeaderBody;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StorableMessageMetaData;
import org.apache.qpid.server.store.StoredMessage;

public class AMQMessageMutator
implements ServerMessageMutator<AMQMessage> {
    private final AMQMessage _message;
    private final MessageStore _messageStore;
    private final BasicContentHeaderProperties _basicContentHeaderProperties;

    AMQMessageMutator(AMQMessage message, MessageStore messageStore) {
        this._message = message;
        this._messageStore = messageStore;
        this._basicContentHeaderProperties = new BasicContentHeaderProperties(this._message.getContentHeaderBody().getProperties());
    }

    public void setPriority(byte priority) {
        this._basicContentHeaderProperties.setPriority(priority);
    }

    public byte getPriority() {
        return this._basicContentHeaderProperties.getPriority();
    }

    public AMQMessage create() {
        long contentSize = this._message.getSize();
        QpidByteBuffer content = this._message.getContent();
        ContentHeaderBody contentHeader = new ContentHeaderBody(this._basicContentHeaderProperties, contentSize);
        MessageMetaData messageMetaData = new MessageMetaData(this._message.getMessagePublishInfo(), contentHeader, this._message.getArrivalTime());
        MessageHandle handle = this._messageStore.addMessage((StorableMessageMetaData)messageMetaData);
        if (content != null) {
            handle.addContent(content);
        }
        return new AMQMessage((StoredMessage<MessageMetaData>)handle.allContentAdded(), this._message.getConnectionReference());
    }
}

