/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CasSerializerSupport;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_stringSubtype;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Misc;

public class FeatureImpl
implements Feature {
    private final int featureCode;
    private short featureOffset = (short)-1;
    private short adjustedFeatureOffset = (short)-1;
    public final boolean isInInt;
    private final boolean isMultipleRefsAllowed;
    public final boolean isLongOrDouble;
    private final TypeImpl highestDefiningType;
    private final TypeImpl rangeType;
    public final boolean isAnnotBaseSofaRef;
    private final String shortName;
    private final SlotKinds.SlotKind slotKind;
    public final int rangeTypeClass;
    private final long hashCodeLong;
    public static final FeatureImpl singleton = new FeatureImpl();

    private FeatureImpl() {
        this.featureCode = 0;
        this.isInInt = false;
        this.rangeType = null;
        this.isMultipleRefsAllowed = false;
        this.isAnnotBaseSofaRef = false;
        this.shortName = null;
        this.slotKind = null;
        this.rangeTypeClass = 0;
        this.isLongOrDouble = false;
        this.highestDefiningType = null;
        this.hashCodeLong = this.computeHashCodeLong();
    }

    FeatureImpl(TypeImpl typeImpl, String shortName, TypeImpl rangeType, TypeSystemImpl tsi, boolean isMultipleRefsAllowed, SlotKinds.SlotKind slotKind) {
        this.highestDefiningType = typeImpl;
        List<FeatureImpl> feats = tsi == null ? null : tsi.features;
        this.featureCode = feats == null ? -1 : feats.size();
        this.rangeType = rangeType;
        this.isLongOrDouble = rangeType == null ? false : rangeType.isLongOrDouble;
        this.slotKind = slotKind;
        this.shortName = shortName;
        this.isMultipleRefsAllowed = isMultipleRefsAllowed;
        this.isAnnotBaseSofaRef = this.highestDefiningType == null ? false : this.highestDefiningType.getCode() == 34 && shortName.equals("sofa");
        this.isInInt = rangeType == null ? false : rangeType.getTypeSystem().isInInt(rangeType);
        this.rangeTypeClass = rangeType == null ? 8 : CasSerializerSupport.classifyType(rangeType);
        this.hashCodeLong = this.computeHashCodeLong();
        if (typeImpl != null) {
            typeImpl.addFeature(this);
            feats.add(this);
        }
    }

    public int getCode() {
        return this.featureCode;
    }

    @Override
    public Type getDomain() {
        return this.highestDefiningType;
    }

    @Override
    public Type getRange() {
        return this.rangeType;
    }

    public TypeImpl getRangeImpl() {
        return this.rangeType;
    }

    public SlotKinds.SlotKind getSlotKind() {
        return this.slotKind;
    }

    @Override
    public String getName() {
        return this.highestDefiningType.getName() + ":" + this.shortName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return String.format("%s [%s: rangeType=%s, isMultipleRefsAllowed=%s, slotKind=%s]", new Object[]{this.getClass().getSimpleName(), this.getName(), this.rangeType, this.isMultipleRefsAllowed, this.slotKind});
    }

    @Override
    public boolean isMultipleReferencesAllowed() {
        return this.isMultipleRefsAllowed;
    }

    public int getOffset() {
        return this.featureOffset;
    }

    void setOffset(int offset) {
        if (offset > Short.MAX_VALUE) {
            throw new RuntimeException("Feature Offset exceeds maximum of 32767");
        }
        this.featureOffset = (short)offset;
    }

    public int getAdjustedOffset() {
        return this.adjustedFeatureOffset;
    }

    void setAdjustedOffset(int offset) {
        if (offset > Short.MAX_VALUE) {
            throw new RuntimeException("Feature Offset exceeds maximum of 32767");
        }
        this.adjustedFeatureOffset = (short)offset;
    }

    TypeImpl getHighestDefiningType() {
        return this.highestDefiningType;
    }

    public void validateIsInAllowedValue(String v) {
        TypeImpl_stringSubtype ti = (TypeImpl_stringSubtype)this.getRangeImpl();
        ti.validateIsInAllowedValues(v);
    }

    public int hashCode() {
        return (int)this.hashCodeLong;
    }

    public long hashCodeLong() {
        return this.hashCodeLong;
    }

    public long computeHashCodeLong() {
        long prime = 31L;
        long result = 31L + Misc.hashStringLong(this.shortName);
        result = 31L * result + (this.highestDefiningType == null ? 0L : this.highestDefiningType.hashCodeNameLong());
        result = 31L * result + (long)(this.isMultipleRefsAllowed ? 1231 : 1237);
        result = 31L * result + (this.rangeType == null ? 0L : this.rangeType.hashCodeNameLong());
        return result;
    }

    @Override
    public int compareTo(Feature o) {
        if (this == o) {
            return 0;
        }
        FeatureImpl other = (FeatureImpl)o;
        if (this.hashCodeLong == other.hashCodeLong) {
            return 0;
        }
        int c = this.shortName.compareTo(other.shortName);
        if (c != 0) {
            return c;
        }
        c = this.highestDefiningType.getName().compareTo(other.highestDefiningType.getName());
        if (c != 0) {
            return c;
        }
        c = Boolean.compare(this.isMultipleRefsAllowed, other.isMultipleRefsAllowed);
        if (c != 0) {
            return c;
        }
        c = this.rangeType.getName().compareTo(other.rangeType.getName());
        if (c != 0) {
            return c;
        }
        throw Misc.internalError();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof FeatureImpl)) {
            return false;
        }
        FeatureImpl other = (FeatureImpl)obj;
        return this.hashCodeLong == other.hashCodeLong;
    }
}

