/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.pear.tools;

import java.io.File;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.uima.pear.tools.InstallationController;
import org.apache.uima.pear.util.FileUtil;

public class PackageSelectorGUI
implements InstallationController.PackageSelector {
    private static final String LAST_PACKAGE_DIR_KEY = "last_package_dir";
    private static final String LAST_PACKAGE_FILE_KEY = "last_package_file";
    private JFrame _dialogFrame = new JFrame();

    public PackageSelectorGUI() {
        this._dialogFrame.setDefaultCloseOperation(0);
    }

    @Override
    public synchronized File selectPackageDirectory(String componentId) {
        Preferences userPrefs = Preferences.userNodeForPackage(this.getClass());
        String lastDirPath = userPrefs != null ? userPrefs.get(LAST_PACKAGE_DIR_KEY, "./") : "./";
        File lastDir = new File(lastDirPath);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new PackageDirFilter());
        fileChooser.setCurrentDirectory(lastDir);
        fileChooser.setFileSelectionMode(1);
        fileChooser.setDialogTitle("Select " + componentId + " root directory");
        String message = "Select the root directory of installed\n\n" + componentId + "\n\ncomponent using the following file dialog,\nor press 'Cancel' in the file dialog, if this\ncomponent is not installed in your file system.";
        JOptionPane.showMessageDialog(this._dialogFrame, message);
        File selectedDir = null;
        int result = fileChooser.showDialog(this._dialogFrame, "Select");
        if (result == 0 && (selectedDir = fileChooser.getSelectedFile()) != null) {
            lastDir = selectedDir.getParentFile();
            userPrefs.put(LAST_PACKAGE_DIR_KEY, lastDir.getAbsolutePath());
        }
        return selectedDir;
    }

    @Override
    public synchronized File selectPackageFile(String componentId) {
        Preferences userPrefs = Preferences.userNodeForPackage(this.getClass());
        String lastFilePath = userPrefs != null ? userPrefs.get(LAST_PACKAGE_FILE_KEY, "") : "";
        File lastFile = lastFilePath.length() > 0 ? new File(lastFilePath) : null;
        File lastDir = lastFile != null ? lastFile.getParentFile() : new File(".");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.addChoosableFileFilter(new PackageFileFilter());
        fileChooser.setCurrentDirectory(lastDir);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Select " + componentId + " PEAR file");
        String message = "Select the PEAR file of the\n\n" + componentId + "\n\ncomponent using the following file dialog.";
        JOptionPane.showMessageDialog(this._dialogFrame, message);
        File selectedFile = null;
        int result = fileChooser.showDialog(this._dialogFrame, "Select");
        if (result == 0 && (selectedFile = fileChooser.getSelectedFile()) != null) {
            userPrefs.put(LAST_PACKAGE_FILE_KEY, selectedFile.getAbsolutePath());
        }
        return selectedFile;
    }

    @Override
    public URL selectPackageUrl(String componentId) {
        return null;
    }

    public static class PackageDirFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Root directories of installed PEAR packages";
        }
    }

    public static class PackageFileFilter
    extends FileFilter {
        private static final String TEAR_EXT = ".tear";
        private static final String PEAR_EXT = ".pear";

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String ext = FileUtil.getFileNameExtension(file.getName()).toLowerCase();
            return ext.equals(TEAR_EXT) || ext.equals(PEAR_EXT);
        }

        @Override
        public String getDescription() {
            return "PEAR package files";
        }
    }
}

