/*
 * Decompiled with CFR 0.152.
 */
package org.dita.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dita.index.IndexEntry;
import org.dita.index.IndexGroup;
import org.dita.index.configuration.ConfigEntry;

class IndexGroupImpl
implements IndexGroup {
    private final String label;
    private final ConfigEntry configEntry;
    private final List<IndexEntry> entries = new ArrayList<IndexEntry>();
    private final List<IndexGroupImpl> childList = new ArrayList<IndexGroupImpl>();

    IndexGroupImpl(String label, ConfigEntry configEntry) {
        this.label = label;
        this.configEntry = configEntry;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Collection<IndexEntry> getEntries() {
        return this.entries;
    }

    ConfigEntry getConfigEntry() {
        return this.configEntry;
    }

    @Override
    public void addEntry(IndexEntry entry) {
        boolean isInserted = false;
        if (!this.childList.isEmpty()) {
            for (int i = 0; i < this.childList.size() && !isInserted; ++i) {
                IndexGroupImpl thisChild = this.childList.get(i);
                List<String> thisGroupMembers = thisChild.getConfigEntry().getGroupMembers();
                if (!this.doesStart(entry.getValue(), thisGroupMembers)) continue;
                thisChild.addEntry(entry);
                isInserted = true;
            }
        }
        if (!isInserted) {
            this.entries.add(entry);
        }
    }

    private boolean doesStart(String sourceString, List<String> compStrings) {
        for (String compString : compStrings) {
            if (!sourceString.startsWith(compString)) continue;
            return true;
        }
        return false;
    }

    private boolean doesStart(List<String> sourceStrings, List<String> compStrings) {
        for (String sourceString2 : sourceStrings) {
            for (String compString : compStrings) {
                if (!sourceString2.startsWith(compString) || sourceString2.equals(compString)) continue;
                return true;
            }
        }
        return false;
    }

    void addChild(IndexGroupImpl group) {
        if (!this.childList.contains(group)) {
            this.childList.add(group);
        }
        for (int i = 0; i < this.childList.size(); ++i) {
            IndexGroupImpl thisChild = this.childList.get(i);
            for (int j = 0; j < this.childList.size(); ++j) {
                List<String> compGroupMembers;
                if (i == j) continue;
                IndexGroupImpl compChild = this.childList.get(j);
                List<String> thisGroupMembers = thisChild.getConfigEntry().getGroupMembers();
                if (!this.doesStart(thisGroupMembers, compGroupMembers = compChild.getConfigEntry().getGroupMembers())) continue;
                this.childList.remove(thisChild);
                compChild.addChild(thisChild);
            }
        }
    }

    @Deprecated
    public void removeChild(IndexGroupImpl indexGroup) {
        this.childList.remove(indexGroup);
    }
}

