/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class VersionInfo {
    private static final Map<Class<?>, VersionInfo> CACHE = new ConcurrentHashMap();
    private final System.Logger logger = System.getLogger(this.getClass().getName());
    private String version;
    private int majorVersion;
    private int minorVersion;

    public static VersionInfo find(Class<?> _class) {
        return CACHE.computeIfAbsent(_class, VersionInfo::new);
    }

    private VersionInfo(Class<?> _class) {
        this.version = Objects.requireNonNullElse(_class, this.getClass()).getPackage().getImplementationVersion();
        if (this.version != null) {
            this.logger.log(System.Logger.Level.DEBUG, "Found version ''{0}'' in package", this.version);
        } else {
            this.version = this.readFromManifest();
            if (this.version == null) {
                this.version = this.readFromMavenPom();
            }
        }
        if (this.version != null) {
            Matcher matcher = Pattern.compile("^([0-9]+)\\.([0-9]+).*").matcher(this.version);
            if (matcher.matches()) {
                this.majorVersion = Integer.valueOf(matcher.group(1));
                this.minorVersion = Integer.valueOf(matcher.group(2));
            } else {
                this.logger.log(System.Logger.Level.WARNING, "Unparsable implementation version: {0}", this.version);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    String readFromManifest() {
        block15: {
            String filename = "MANIFEST.MF";
            Path currDir = Paths.get("", new String[0]).toAbsolutePath();
            this.logger.log(System.Logger.Level.DEBUG, "Searching manifest under current directory ''{0}''", currDir);
            try (Stream<Path> walk = Files.walk(currDir, new FileVisitOption[0]);){
                String string;
                block16: {
                    Path manifest = walk.filter(p -> p.getFileName().toString().equals(filename)).findFirst().orElse(null);
                    if (manifest == null) {
                        this.logger.log(System.Logger.Level.DEBUG, "Could not find ''{0}'' in path ''{1}''", filename, currDir);
                        break block15;
                    }
                    InputStream is = Files.newInputStream(manifest, StandardOpenOption.READ);
                    try {
                        String ver = new Manifest(is).getMainAttributes().getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        this.logger.log(System.Logger.Level.DEBUG, "Found version ''{0}'' in manifest", ver);
                        string = ver;
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return string;
            }
            catch (IOException _ex) {
                this.logger.log(System.Logger.Level.WARNING, "Failed to find version info in manifest: {0}", _ex.toString());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readFromMavenPom() {
        String filename = "pom.xml";
        Path currDir = Paths.get("", new String[0]).toAbsolutePath();
        this.logger.log(System.Logger.Level.DEBUG, "Searching maven pom under current directory ''{0}''", currDir);
        try (Stream<Path> walk = Files.walk(currDir, new FileVisitOption[0]);){
            Path pom = walk.filter(p -> p.getFileName().toString().equals(filename)).findFirst().orElse(null);
            if (pom == null) {
                this.logger.log(System.Logger.Level.WARNING, "Failed to find ''{0}'' in path ''{1}''", filename, currDir);
                return null;
            }
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(pom.toFile());
            Element docElem = document.getDocumentElement();
            docElem.normalize();
            NodeList nodeList = docElem.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element && "version".equals(node.getNodeName())) {
                    String ver = node.getTextContent();
                    this.logger.log(System.Logger.Level.DEBUG, "Found version ''{0}'' in maven pom", ver);
                    String string = ver;
                    return string;
                }
                ++i;
            }
            return null;
        }
        catch (IOException | ParserConfigurationException | SAXException _ex) {
            this.logger.log(System.Logger.Level.WARNING, "Failed to find version info in maven pom: {0}", _ex.toString());
        }
        return null;
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return String.format("%s[version=%s, major=%d, minor=%d]", this.getClass().getSimpleName(), this.version, this.majorVersion, this.minorVersion);
    }
}

