/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow;

import java.util.List;
import org.apache.hop.base.BaseHopMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.w3c.dom.Node;

public class WorkflowHopMeta
extends BaseHopMeta<ActionMeta>
implements Cloneable {
    private static final Class<?> PKG = WorkflowHopMeta.class;
    public static final String XML_EVALUATION_TAG = "evaluation";
    public static final String XML_UNCONDITIONAL_TAG = "unconditional";
    private static final String CONST_SPACE = "      ";
    private boolean evaluation;
    private boolean unconditional;

    public WorkflowHopMeta() {
        super(false, null, null, true, true, false);
    }

    public WorkflowHopMeta(WorkflowHopMeta hop) {
        super(hop.isSplit(), hop.getFromAction(), hop.getToAction(), hop.isEnabled(), hop.hasChanged(), hop.isErrorHop());
        this.evaluation = hop.evaluation;
        this.unconditional = hop.unconditional;
    }

    public WorkflowHopMeta(ActionMeta from, ActionMeta to) {
        this.from = from;
        this.to = to;
        this.enabled = true;
        this.split = false;
        this.evaluation = true;
        this.unconditional = false;
        if (from != null && from.isStart()) {
            this.setUnconditional();
        }
    }

    public WorkflowHopMeta(Node hopNode, List<ActionMeta> actions) throws HopXmlException {
        try {
            this.from = this.searchAction(actions, XmlHandler.getTagValue((Node)hopNode, (String)"from"));
            this.to = this.searchAction(actions, XmlHandler.getTagValue((Node)hopNode, (String)"to"));
            this.enabled = this.getTagValueAsBoolean(hopNode, "enabled", true);
            this.evaluation = this.getTagValueAsBoolean(hopNode, XML_EVALUATION_TAG, true);
            this.unconditional = this.getTagValueAsBoolean(hopNode, XML_UNCONDITIONAL_TAG, false);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowHopMeta.Exception.UnableToLoadHopInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public WorkflowHopMeta clone() {
        return new WorkflowHopMeta(this);
    }

    public String toString() {
        String strEnabled;
        String strFrom = this.from == null ? "(empty)" : ((ActionMeta)this.from).getName();
        String strTo = this.to == null ? "(empty)" : ((ActionMeta)this.to).getName();
        String string = strEnabled = this.enabled ? "enabled" : "disabled";
        String strEvaluation = this.unconditional ? XML_UNCONDITIONAL_TAG : (this.evaluation ? "success" : "failure");
        return strFrom + " --> " + strTo + " [" + strEnabled + ", " + strEvaluation + ")";
    }

    private ActionMeta searchAction(List<ActionMeta> actions, String name) {
        for (ActionMeta action : actions) {
            if (!action.getName().equalsIgnoreCase(name)) continue;
            return action;
        }
        return null;
    }

    public WorkflowHopMeta(Node hopNode, WorkflowMeta workflow) throws HopXmlException {
        try {
            String fromName = XmlHandler.getTagValue((Node)hopNode, (String)"from");
            String toName = XmlHandler.getTagValue((Node)hopNode, (String)"to");
            this.from = workflow.findAction(fromName);
            this.to = workflow.findAction(toName);
            this.enabled = this.getTagValueAsBoolean(hopNode, "enabled", true);
            this.evaluation = this.getTagValueAsBoolean(hopNode, XML_EVALUATION_TAG, true);
            this.unconditional = this.getTagValueAsBoolean(hopNode, XML_UNCONDITIONAL_TAG, false);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"WorkflowHopMeta.Exception.UnableToLoadHopInfoXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(200);
        if (null != this.from && null != this.to) {
            xml.append("    ").append(XmlHandler.openTag((String)"hop")).append(Const.CR);
            xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"from", (String)((ActionMeta)this.from).getName()));
            xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"to", (String)((ActionMeta)this.to).getName()));
            xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"enabled", (boolean)this.enabled));
            xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)XML_EVALUATION_TAG, (boolean)this.evaluation));
            xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)XML_UNCONDITIONAL_TAG, (boolean)this.unconditional));
            xml.append("    ").append(XmlHandler.closeTag((String)"hop")).append(Const.CR);
        }
        return xml.toString();
    }

    @Deprecated(since="2.10")
    public boolean getEvaluation() {
        return this.evaluation;
    }

    public boolean isEvaluation() {
        return this.evaluation;
    }

    public void setEvaluation() {
        if (!this.evaluation) {
            this.setChanged();
        }
        this.setEvaluation(true);
    }

    public void setEvaluation(boolean e) {
        if (this.evaluation != e) {
            this.setChanged();
        }
        this.evaluation = e;
    }

    public void setUnconditional() {
        if (!this.unconditional) {
            this.setChanged();
        }
        this.unconditional = true;
    }

    public void setConditional() {
        if (this.unconditional) {
            this.setChanged();
        }
        this.unconditional = false;
    }

    public boolean isUnconditional() {
        return this.unconditional;
    }

    public String getDescription() {
        if (this.isUnconditional()) {
            return BaseMessages.getString(PKG, (String)"WorkflowHopMeta.Msg.ExecNextActionUncondition", (String[])new String[0]);
        }
        if (this.isEvaluation()) {
            return BaseMessages.getString(PKG, (String)"WorkflowHopMeta.Msg.ExecNextActionFlawLess", (String[])new String[0]);
        }
        return BaseMessages.getString(PKG, (String)"WorkflowHopMeta.Msg.ExecNextActionFailed", (String[])new String[0]);
    }

    public ActionMeta getFromAction() {
        return (ActionMeta)this.from;
    }

    public void setFromAction(ActionMeta fromAction) {
        this.from = fromAction;
        this.changed = true;
    }

    public ActionMeta getToAction() {
        return (ActionMeta)this.to;
    }

    public void setToAction(ActionMeta toAction) {
        this.to = toAction;
        this.changed = true;
    }

    public void setUnconditional(boolean unconditional) {
        if (this.unconditional != unconditional) {
            this.setChanged();
        }
        this.unconditional = unconditional;
    }
}

