/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.neo4j.model.GraphNode;
import org.apache.hop.neo4j.model.GraphPresentation;
import org.apache.hop.neo4j.model.GraphProperty;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.model.GraphRelationship;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@HopMetadata(key="neo4j-graph-model", name="i18n::GraphModel.name", description="i18n::GraphModel.description", image="neo4j_logo.svg", documentationUrl="/metadata-types/neo4j/neo4j-graphmodel.html", hopMetadataPropertyType=HopMetadataPropertyType.GRAPH_MODEL)
public class GraphModel
extends HopMetadataBase
implements IHopMetadata {
    public static final String CONST_DESCRIPTION = "description";
    public static final String CONST_PROPERTIES = "properties";
    @HopMetadataProperty
    protected String description;
    @HopMetadataProperty
    protected List<GraphNode> nodes;
    @HopMetadataProperty
    protected List<GraphRelationship> relationships;

    public GraphModel() {
        this.nodes = new ArrayList<GraphNode>();
        this.relationships = new ArrayList<GraphRelationship>();
    }

    public GraphModel(String name, String description, List<GraphNode> nodes, List<GraphRelationship> relationships) {
        this.name = name;
        this.description = description;
        this.nodes = nodes;
        this.relationships = relationships;
    }

    public GraphModel(String jsonModelString) throws HopException {
        this();
        try {
            JSONArray jsonRelationships;
            JSONArray jsonProperties;
            JSONParser parser = new JSONParser();
            JSONObject jsonModel = (JSONObject)parser.parse(jsonModelString);
            this.setName((String)jsonModel.get((Object)"name"));
            this.setDescription((String)jsonModel.get((Object)CONST_DESCRIPTION));
            JSONArray jsonNodes = (JSONArray)jsonModel.get((Object)"nodes");
            if (jsonNodes != null) {
                for (Object jsonNode1 : jsonNodes) {
                    JSONObject jsonPresentation;
                    JSONObject jsonNode = (JSONObject)jsonNode1;
                    GraphNode graphNode = new GraphNode();
                    graphNode.setName((String)jsonNode.get((Object)"name"));
                    graphNode.setDescription((String)jsonNode.get((Object)CONST_DESCRIPTION));
                    JSONArray jsonLabels = (JSONArray)jsonNode.get((Object)"labels");
                    if (jsonLabels != null) {
                        for (Object jsonLabel : jsonLabels) {
                            graphNode.getLabels().add((String)jsonLabel);
                        }
                    }
                    if ((jsonProperties = (JSONArray)jsonNode.get((Object)CONST_PROPERTIES)) != null) {
                        Object jsonLabel;
                        jsonLabel = jsonProperties.iterator();
                        while (jsonLabel.hasNext()) {
                            JSONObject jsonProperty = (JSONObject)jsonLabel.next();
                            graphNode.getProperties().add(this.parseGraphPropertyJson(jsonProperty));
                        }
                    }
                    if ((jsonPresentation = (JSONObject)jsonNode.get((Object)"presentation")) != null) {
                        long x = (Long)jsonPresentation.get((Object)"x");
                        long y = (Long)jsonPresentation.get((Object)"y");
                        graphNode.setPresentation(new GraphPresentation((int)x, (int)y));
                    }
                    this.nodes.add(graphNode);
                }
            }
            if ((jsonRelationships = (JSONArray)jsonModel.get((Object)"relationships")) != null) {
                for (Object jsonRelationship1 : jsonRelationships) {
                    JSONObject jsonRelationship = (JSONObject)jsonRelationship1;
                    GraphRelationship graphRelationship = new GraphRelationship();
                    graphRelationship.setName((String)jsonRelationship.get((Object)"name"));
                    graphRelationship.setDescription((String)jsonRelationship.get((Object)CONST_DESCRIPTION));
                    graphRelationship.setLabel((String)jsonRelationship.get((Object)"label"));
                    graphRelationship.setNodeSource((String)jsonRelationship.get((Object)"source"));
                    graphRelationship.setNodeTarget((String)jsonRelationship.get((Object)"target"));
                    jsonProperties = (JSONArray)jsonRelationship.get((Object)CONST_PROPERTIES);
                    if (jsonProperties != null) {
                        for (JSONObject jsonProperty : jsonProperties) {
                            graphRelationship.getProperties().add(this.parseGraphPropertyJson(jsonProperty));
                        }
                    }
                    this.relationships.add(graphRelationship);
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error serializing to JSON", (Throwable)e);
        }
    }

    private GraphProperty parseGraphPropertyJson(JSONObject jsonProperty) {
        GraphProperty graphProperty = new GraphProperty();
        graphProperty.setName((String)jsonProperty.get((Object)"name"));
        graphProperty.setDescription((String)jsonProperty.get((Object)CONST_DESCRIPTION));
        graphProperty.setPrimary((Boolean)jsonProperty.get((Object)"primary"));
        graphProperty.setType(GraphPropertyType.parseCode((String)jsonProperty.get((Object)"type")));
        return graphProperty;
    }

    public String getJSONString() throws HopException {
        try {
            JSONArray jsonProperties;
            JSONObject jsonModel = new JSONObject();
            jsonModel.put((Object)"name", (Object)this.name);
            if (StringUtils.isNotEmpty((String)this.description)) {
                jsonModel.put((Object)CONST_DESCRIPTION, (Object)this.description);
            }
            JSONArray jsonNodes = new JSONArray();
            for (GraphNode graphNode : this.nodes) {
                JSONObject jsonNode = new JSONObject();
                jsonNode.put((Object)"name", (Object)graphNode.getName());
                if (StringUtils.isNotEmpty((String)graphNode.getDescription())) {
                    jsonNode.put((Object)CONST_DESCRIPTION, (Object)graphNode.getDescription());
                }
                JSONArray jsonLabels = new JSONArray();
                for (String string : graphNode.getLabels()) {
                    jsonLabels.add((Object)string);
                }
                jsonNode.put((Object)"labels", (Object)jsonLabels);
                jsonProperties = new JSONArray();
                for (GraphProperty graphProperty : graphNode.getProperties()) {
                    jsonProperties.add((Object)this.getJsonProperty(graphProperty));
                }
                jsonNode.put((Object)CONST_PROPERTIES, (Object)jsonProperties);
                GraphPresentation graphPresentation = graphNode.getPresentation();
                JSONObject jsonPresentation = new JSONObject();
                jsonPresentation.put((Object)"x", (Object)graphPresentation.getX());
                jsonPresentation.put((Object)"y", (Object)graphPresentation.getY());
                jsonNode.put((Object)"presentation", (Object)jsonPresentation);
                jsonNodes.add((Object)jsonNode);
            }
            jsonModel.put((Object)"nodes", (Object)jsonNodes);
            JSONArray jsonRelationships = new JSONArray();
            for (GraphRelationship graphRelationship : this.relationships) {
                JSONObject jsonRelationship = new JSONObject();
                jsonRelationship.put((Object)"name", (Object)graphRelationship.getName());
                if (StringUtils.isNotEmpty((String)graphRelationship.getDescription())) {
                    jsonRelationship.put((Object)CONST_DESCRIPTION, (Object)graphRelationship.getDescription());
                }
                jsonRelationship.put((Object)"label", (Object)graphRelationship.getLabel());
                jsonRelationship.put((Object)"source", (Object)graphRelationship.getNodeSource());
                jsonRelationship.put((Object)"target", (Object)graphRelationship.getNodeTarget());
                jsonProperties = new JSONArray();
                for (GraphProperty graphProperty : graphRelationship.getProperties()) {
                    jsonProperties.add((Object)this.getJsonProperty(graphProperty));
                }
                jsonRelationship.put((Object)CONST_PROPERTIES, (Object)jsonProperties);
                jsonRelationships.add((Object)jsonRelationship);
            }
            jsonModel.put((Object)"relationships", (Object)jsonRelationships);
            String string = jsonModel.toJSONString();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse(string);
            return gson.toJson(je);
        }
        catch (Exception e) {
            throw new HopException("Error encoding model in JSON", (Throwable)e);
        }
    }

    private JSONObject getJsonProperty(GraphProperty graphProperty) {
        JSONObject jsonProperty = new JSONObject();
        jsonProperty.put((Object)"name", (Object)graphProperty.getName());
        if (StringUtils.isNotEmpty((String)graphProperty.getDescription())) {
            jsonProperty.put((Object)CONST_DESCRIPTION, (Object)graphProperty.getDescription());
        }
        jsonProperty.put((Object)"type", (Object)GraphPropertyType.getCode(graphProperty.getType()));
        jsonProperty.put((Object)"primary", (Object)graphProperty.isPrimary());
        return jsonProperty;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof GraphModel)) {
            return false;
        }
        if (object == this) {
            return true;
        }
        return this.name.equalsIgnoreCase(((GraphModel)((Object)object)).getName());
    }

    public GraphModel(GraphModel source) {
        this();
        this.replace(source);
    }

    public void replace(GraphModel source) {
        this.setName(source.getName());
        this.setDescription(source.getDescription());
        this.nodes = new ArrayList<GraphNode>();
        for (GraphNode node : source.getNodes()) {
            this.nodes.add(new GraphNode(node));
        }
        this.relationships = new ArrayList<GraphRelationship>();
        for (GraphRelationship relationship : source.getRelationships()) {
            this.relationships.add(new GraphRelationship(relationship));
        }
    }

    public GraphNode findNode(String nodeName) {
        for (GraphNode node : this.nodes) {
            if (!node.getName().equalsIgnoreCase(nodeName)) continue;
            return node;
        }
        return null;
    }

    public String[] getNodeNames() {
        Object[] names = new String[this.nodes.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.nodes.get(i).getName();
        }
        Arrays.sort(names);
        return names;
    }

    public GraphRelationship findRelationship(String relationshipName) {
        for (GraphRelationship relationship : this.relationships) {
            if (!relationship.getName().equalsIgnoreCase(relationshipName)) continue;
            return relationship;
        }
        return null;
    }

    public String[] getRelationshipNames() {
        Object[] names = new String[this.relationships.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.relationships.get(i).getName();
        }
        Arrays.sort(names);
        return names;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<GraphNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<GraphNode> nodes) {
        this.nodes = nodes;
    }

    public List<GraphRelationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<GraphRelationship> relationships) {
        this.relationships = relationships;
    }

    public GraphRelationship findRelationship(String source, String target) {
        for (GraphRelationship relationship : this.relationships) {
            if (!relationship.getNodeSource().equalsIgnoreCase(source) || !relationship.getNodeTarget().equalsIgnoreCase(target)) continue;
            return relationship;
        }
        return null;
    }

    public List<GraphRelationship> findRelationships(String source, String target) {
        ArrayList<GraphRelationship> list = new ArrayList<GraphRelationship>();
        for (GraphRelationship relationship : this.relationships) {
            if (!relationship.getNodeSource().equalsIgnoreCase(source) || !relationship.getNodeTarget().equalsIgnoreCase(target)) continue;
            list.add(relationship);
        }
        return list;
    }

    public void validateIntegrity() throws HopException {
        for (GraphNode node : this.nodes) {
            node.validateIntegrity();
        }
        for (GraphRelationship relationship : this.relationships) {
            relationship.validateIntegrity(this.nodes);
        }
    }
}

