/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.IFSObjAttrs2;
import com.ibm.as400.access.Trace;

class IFSChangeAttrsReq
extends IFSDataStreamReq {
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int CCSID_OFFSET = 26;
    private static final int WORKING_DIR_HANDLE_OFFSET = 28;
    private static final int ATTR_LIST_LEVEL_OFFSET = 32;
    private static final int CREATE_DATE_OFFSET = 34;
    private static final int MODIFY_DATE_OFFSET = 42;
    private static final int ACCESS_DATE_OFFSET = 50;
    private static final int SET_FLAGS_OFFSET = 58;
    private static final int FIXED_ATTRS_OFFSET = 60;
    private static final int FILE_SIZE_OFFSET = 64;
    private static final int LARGE_FILE_SIZE_OFFSET = 68;

    IFSChangeAttrsReq(int fileHandle, long fileSize, int datastreamLevel) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(11);
        this.set32bit(fileHandle, 22);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setData(0L, 34);
        this.setData(0L, 42);
        this.setData(0L, 50);
        this.set16bit(1, 58);
        this.setFileSizeFields(fileSize, datastreamLevel);
    }

    IFSChangeAttrsReq(int fileHandle, long createDate, long modifyDate, long accessDate, int datastreamLevel) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(11);
        this.set32bit(fileHandle, 22);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setDate(createDate, 34);
        this.setDate(modifyDate, 42);
        this.setDate(accessDate, 50);
        this.set16bit(0, 58);
    }

    IFSChangeAttrsReq(byte[] fileName, int fileNameCCSID, long fileSize, int datastreamLevel) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(datastreamLevel) + 6 + fileName.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(fileNameCCSID, 26);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setData(0L, 34);
        this.setData(0L, 42);
        this.setData(0L, 50);
        this.set16bit(1, 58);
        this.setFileSizeFields(fileSize, datastreamLevel);
        this.set32bit(fileName.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(datastreamLevel));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(datastreamLevel));
        System.arraycopy(fileName, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(datastreamLevel), fileName.length);
    }

    IFSChangeAttrsReq(byte[] fileName, int fileNameCCSID, int fixedAttributes, boolean extraneousDataToMakeSignatureUnique, int datastreamLevel) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(datastreamLevel) + 6 + fileName.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(fileNameCCSID, 26);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setData(0L, 34);
        this.setData(0L, 42);
        this.setData(0L, 50);
        this.set16bit(2, 58);
        this.set32bit(fixedAttributes, 60);
        this.setFileSizeFields(0L, datastreamLevel);
        this.set32bit(fileName.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(datastreamLevel));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(datastreamLevel));
        System.arraycopy(fileName, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(datastreamLevel), fileName.length);
    }

    IFSChangeAttrsReq(byte[] fileName, int fileNameCCSID, long createDate, long modifyDate, long accessDate, int datastreamLevel) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(datastreamLevel) + 6 + fileName.length);
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(fileNameCCSID, 26);
        this.set32bit(1, 28);
        this.set16bit(1, 32);
        this.setDate(createDate, 34);
        this.setDate(modifyDate, 42);
        this.setDate(accessDate, 50);
        this.set16bit(0, 58);
        this.set32bit(fileName.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(datastreamLevel));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(datastreamLevel));
        System.arraycopy(fileName, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(datastreamLevel), fileName.length);
    }

    IFSChangeAttrsReq(byte[] fileName, int fileNameCCSID, IFSObjAttrs2 oa2Structure, int datastreamLevel) {
        super(20 + IFSChangeAttrsReq.getTemplateLength(datastreamLevel) + 6 + fileName.length + 6 + oa2Structure.length());
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSChangeAttrsReq.getTemplateLength(datastreamLevel));
        this.setReqRepID(11);
        this.set32bit(0, 22);
        this.set16bit(fileNameCCSID, 26);
        this.set32bit(1, 28);
        this.set16bit(5, 32);
        this.set16bit(0, 58);
        this.set32bit(fileName.length + 6, IFSChangeAttrsReq.getFilenameLLOffset(datastreamLevel));
        this.set16bit(2, IFSChangeAttrsReq.getFilenameCPOffset(datastreamLevel));
        System.arraycopy(fileName, 0, this.data_, IFSChangeAttrsReq.getFilenameOffset(datastreamLevel), fileName.length);
        int offset = IFSChangeAttrsReq.getFilenameOffset(datastreamLevel) + fileName.length;
        this.set32bit(oa2Structure.getLength() + 6, offset);
        this.set16bit(15, offset + 4);
        System.arraycopy(oa2Structure.getData(), 0, this.data_, offset + 6, oa2Structure.length());
    }

    private static final int getTemplateLength(int datastreamLevel) {
        return datastreamLevel < 16 ? 48 : 56;
    }

    private static final int getFilenameLLOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 68 : 76;
    }

    private static final int getFilenameCPOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 72 : 80;
    }

    private static final int getFilenameOffset(int datastreamLevel) {
        return datastreamLevel < 16 ? 74 : 82;
    }

    private final void setFileSizeFields(long fileSize, int datastreamLevel) {
        if (datastreamLevel < 16) {
            if (fileSize > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified fileSize value (" + fileSize + ") exceeds maximum file length supported by system.");
                }
                fileSize = Integer.MAX_VALUE;
            }
            this.set32bit((int)fileSize, 64);
        } else {
            this.set32bit(0, 64);
            this.set64bit(fileSize, 68);
        }
    }
}

