/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class JDDataSourceURL
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final String PROTOCOL_ = "jdbc";
    private static final String SUB_PROTOCOL_ = "as400";
    private static final String NATIVE_SUB_PROTOCOL_ = "db2";
    private boolean extraPathSpecified_;
    private boolean portSpecified_;
    private Properties properties_;
    private String schema_;
    private String serverName_;
    private String url_;
    private boolean valid_;
    private String secondaryUrl_;
    private transient int portNumber_ = 0;

    public JDDataSourceURL(String url) {
        this.extraPathSpecified_ = false;
        this.portSpecified_ = false;
        this.properties_ = new Properties();
        this.schema_ = "";
        this.secondaryUrl_ = "";
        this.serverName_ = "";
        this.url_ = url;
        this.valid_ = false;
        if (url != null) {
            this.parseURL(url);
            if (this.valid_) {
                if (this.properties_.containsKey("secondary URL")) {
                    this.secondaryUrl_ = (String)this.properties_.get("secondary URL");
                }
                if (this.secondaryUrl_.indexOf("\\;") != -1) {
                    StringBuffer buf = new StringBuffer(this.secondaryUrl_.length());
                    int subsequentChar = 32;
                    for (int i = this.secondaryUrl_.length() - 1; i > -1; --i) {
                        char thisChar = this.secondaryUrl_.charAt(i);
                        if (thisChar != '\\' || subsequentChar != 59) {
                            buf.insert(0, thisChar);
                        }
                        subsequentChar = thisChar;
                    }
                    this.secondaryUrl_ = buf.toString();
                    this.properties_.put("secondary URL", this.secondaryUrl_);
                }
            }
        }
    }

    public JDDataSourceURL(JDDataSourceURL originalDataSourceUrl_, String server, String port) {
        this.extraPathSpecified_ = originalDataSourceUrl_.extraPathSpecified_;
        this.properties_ = (Properties)originalDataSourceUrl_.properties_.clone();
        this.schema_ = originalDataSourceUrl_.schema_;
        this.valid_ = originalDataSourceUrl_.valid_;
        this.secondaryUrl_ = originalDataSourceUrl_.secondaryUrl_;
        this.serverName_ = server;
        int portNumber = 0;
        if (port != null) {
            try {
                portNumber = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                portNumber = 0;
            }
        }
        if (portNumber == 0) {
            this.portSpecified_ = false;
            this.portNumber_ = 0;
        } else {
            this.portSpecified_ = true;
            this.portNumber_ = portNumber;
        }
        this.regenerateUrl();
    }

    void regenerateUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append("jdbc:as400:");
        sb.append(this.serverName_);
        if (this.portSpecified_) {
            sb.append(":");
            sb.append(this.portNumber_);
        }
        if (this.schema_ != null && this.schema_.length() > 0) {
            sb.append("/");
            sb.append(this.schema_);
        }
        Enumeration<Object> keyEnum = this.properties_.keys();
        while (keyEnum.hasMoreElements()) {
            String key = (String)keyEnum.nextElement();
            String value = this.properties_.getProperty(key);
            sb.append(";");
            sb.append(key);
            sb.append("=");
            sb.append(value);
        }
        this.url_ = sb.toString();
    }

    String getNativeURL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PROTOCOL_);
        buffer.append(':');
        buffer.append(NATIVE_SUB_PROTOCOL_);
        buffer.append(':');
        buffer.append("LOCALHOST");
        String user = this.properties_.getProperty("user");
        String pass = this.properties_.getProperty("password");
        if (user != null) {
            buffer.append(";user=" + user);
        }
        if (pass != null) {
            buffer.append(";password=" + pass);
        }
        Enumeration<Object> en = this.properties_.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            buffer.append(";" + key + "=" + this.properties_.getProperty(key));
        }
        return buffer.toString();
    }

    Properties getProperties() {
        return this.properties_;
    }

    public String getSchema() throws SQLException {
        int length = this.schema_.length();
        if (length > 128) {
            return null;
        }
        return this.schema_;
    }

    String getSecondaryURL() {
        return this.secondaryUrl_;
    }

    public String getServerName() {
        return this.serverName_;
    }

    private static int indexOfEither(String s, String a, String b, int fromIndex) {
        int ia = s.indexOf(a, fromIndex);
        int ib = s.indexOf(b, fromIndex);
        if (ia == -1) {
            return ib;
        }
        if (ib == -1) {
            return ia;
        }
        return Math.min(ia, ib);
    }

    boolean isExtraPathSpecified() {
        return this.extraPathSpecified_;
    }

    public boolean isPortSpecified() {
        return this.portSpecified_;
    }

    public boolean isValid() {
        return this.valid_;
    }

    private void parseURL(String url) {
        int urlLength = url.length();
        int mark1 = url.indexOf(":");
        if (mark1 == -1) {
            return;
        }
        if (!url.substring(0, mark1).equalsIgnoreCase(PROTOCOL_)) {
            return;
        }
        int mark2 = JDDataSourceURL.indexOfEither(url, ":", ";", mark1 + 1);
        if (mark2 == -1) {
            mark2 = urlLength;
        }
        if (!url.substring(mark1 + 1, mark2).equalsIgnoreCase(SUB_PROTOCOL_)) {
            return;
        }
        this.valid_ = true;
        String subname = mark2 == urlLength ? "" : (url.charAt(mark2) == ':' ? url.substring(mark2 + 1) : url.substring(mark2));
        int tokenCount = 0;
        int nextSemicolonPos = 0;
        int priorSemicolonPos = -1;
        int searchPos = 0;
        while (nextSemicolonPos != -1) {
            String token;
            nextSemicolonPos = subname.indexOf(59, searchPos);
            if (nextSemicolonPos == -1) {
                token = subname.substring(priorSemicolonPos + 1);
            } else {
                if (nextSemicolonPos > 0 && subname.charAt(nextSemicolonPos - 1) == '\\') {
                    searchPos = nextSemicolonPos + 1;
                    continue;
                }
                token = subname.substring(priorSemicolonPos + 1, nextSemicolonPos);
            }
            int nextQuote = -1;
            if (token.indexOf(34) != -1) {
                if (token.endsWith("\"")) {
                    nextQuote = nextSemicolonPos - 1;
                } else {
                    nextQuote = subname.indexOf(34, nextSemicolonPos);
                    token = token + subname.substring(nextSemicolonPos, nextQuote + 1);
                    nextSemicolonPos = subname.indexOf(59, nextQuote);
                }
            }
            if (++tokenCount == 1) {
                int slash2;
                int colonIndex;
                int braceIndex;
                int slash;
                if (token.length() >= 2 && token.substring(0, 2).equals("//")) {
                    token = token.substring(2);
                }
                if ((slash = token.indexOf(47)) == -1) {
                    this.serverName_ = token;
                } else {
                    this.serverName_ = token.substring(0, slash);
                    this.schema_ = token.substring(slash + 1);
                }
                boolean ipV6Name = false;
                if (this.serverName_.length() > 0 && this.serverName_.charAt(0) == '[' && (braceIndex = this.serverName_.indexOf(93)) > 0) {
                    int colonIndex2 = this.serverName_.indexOf(58, braceIndex);
                    if (colonIndex2 != -1) {
                        this.portSpecified_ = true;
                        this.setPortNumber(colonIndex2);
                    }
                    this.serverName_ = this.serverName_.substring(1, braceIndex);
                    ipV6Name = true;
                }
                if (!ipV6Name && (colonIndex = this.serverName_.indexOf(58)) != -1) {
                    this.portSpecified_ = true;
                    this.setPortNumber(colonIndex);
                    this.serverName_ = this.serverName_.substring(0, colonIndex);
                }
                if ((slash2 = this.schema_.indexOf(47)) != -1 && nextQuote == -1) {
                    this.schema_ = this.schema_.substring(0, slash2);
                    this.extraPathSpecified_ = true;
                }
            } else {
                String value;
                String key;
                int equalSignPos = token.indexOf(61);
                if (equalSignPos == -1) {
                    key = token.trim();
                    value = "";
                } else {
                    key = token.substring(0, equalSignPos).trim();
                    value = token.substring(equalSignPos + 1).trim();
                }
                this.properties_.put(key, value);
            }
            priorSemicolonPos = nextSemicolonPos;
            searchPos = priorSemicolonPos + 1;
        }
    }

    private void setPortNumber(int colonIndex) {
        try {
            this.portNumber_ = Integer.parseInt(this.serverName_.substring(colonIndex + 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getPortNumber() {
        return this.portNumber_;
    }

    public String toString() {
        return this.url_;
    }
}

