/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.access.Trace;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public class SQLConnection
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    private transient String password_ = null;
    private transient String uid_ = null;
    private String uid2_ = null;
    private Properties properties_ = null;
    private transient Properties properties2_ = null;
    private transient String url_ = null;
    private String url2_ = null;
    private transient Connection connection_ = null;
    private transient PropertyChangeSupport changeListeners_ = new PropertyChangeSupport(this);
    private transient VetoableChangeSupport vetoListeners_ = new VetoableChangeSupport(this);
    private transient WorkingEventSupport workingListeners_ = new WorkingEventSupport(this);

    public SQLConnection() {
    }

    public SQLConnection(String URL2) {
        if (URL2 == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = URL2;
    }

    public SQLConnection(String URL2, String userName) {
        if (URL2 == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = URL2;
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        this.uid_ = this.uid2_ = userName;
    }

    public SQLConnection(String URL2, String userName, String password) {
        if (URL2 == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = URL2;
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        this.uid_ = this.uid2_ = userName;
        if (password == null) {
            throw new NullPointerException("password");
        }
        this.password_ = password;
    }

    public SQLConnection(String URL2, Properties properties) {
        if (URL2 == null) {
            throw new NullPointerException("URL");
        }
        this.url_ = this.url2_ = URL2;
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        this.properties2_ = properties;
        this.properties_ = new Properties();
        Enumeration<?> e = this.properties2_.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            this.properties_.put(prop, this.properties2_.getProperty(prop));
        }
        this.properties_.remove("password");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.addPropertyChangeListener(listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.addVetoableChangeListener(listener);
    }

    public void addWorkingListener(WorkingListener listener) {
        this.workingListeners_.addWorkingListener(listener);
    }

    public void close() throws SQLException {
        if (this.connection_ != null) {
            this.connection_.close();
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.connection_ == null) {
            if (this.url2_ == null) {
                throw new IllegalStateException("URL");
            }
            this.workingListeners_.fireStartWorking();
            try {
                if (this.uid2_ != null) {
                    Trace.log(3, "Getting SQL Connection with uid, pwd.");
                    this.connection_ = DriverManager.getConnection(this.url2_, this.uid2_, this.password_);
                } else if (this.properties2_ != null) {
                    Trace.log(3, "Getting SQL Connection with properties.");
                    this.connection_ = DriverManager.getConnection(this.url2_, this.properties2_);
                } else {
                    Trace.log(3, "Getting SQL Connection with url only.");
                    this.connection_ = DriverManager.getConnection(this.url2_);
                }
                Trace.log(3, "Got SQL Connection.");
            }
            catch (SQLException e) {
                this.workingListeners_.fireStopWorking();
                Trace.log(2, "Error getting SQL Connection: " + e.getMessage());
                throw e;
            }
            this.uid_ = null;
            this.url_ = null;
            try {
                DatabaseMetaData meta = this.connection_.getMetaData();
                this.uid_ = meta.getUserName();
                this.url_ = meta.getURL();
            }
            catch (SQLException e) {
                Trace.log(4, "Error getting SQL meta data: " + e.getMessage());
            }
            this.workingListeners_.fireStopWorking();
        }
        return this.connection_;
    }

    public Properties getProperties() {
        return this.properties_;
    }

    public String getURL() {
        if (this.url_ == null) {
            return "";
        }
        return this.url_;
    }

    public String getUserName() {
        if (this.uid_ == null) {
            return "";
        }
        return this.uid_;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.changeListeners_ = new PropertyChangeSupport(this);
        this.vetoListeners_ = new VetoableChangeSupport(this);
        this.workingListeners_ = new WorkingEventSupport(this);
        this.password_ = null;
        this.connection_ = null;
        this.url_ = this.url2_;
        this.uid_ = this.uid2_;
        this.properties2_ = this.properties_;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeListeners_.removePropertyChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoListeners_.removeVetoableChangeListener(listener);
    }

    public void removeWorkingListener(WorkingListener listener) {
        this.workingListeners_.removeWorkingListener(listener);
    }

    public void setPassword(String password) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (password == null) {
            throw new NullPointerException("password");
        }
        if (this.password_ != null && this.password_.equals(password)) {
            return;
        }
        this.vetoListeners_.fireVetoableChange("password", null, "");
        this.password_ = password;
        this.changeListeners_.firePropertyChange("password", null, "");
    }

    public void setProperties(Properties properties) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        Properties temp = new Properties();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            temp.put(prop, properties.getProperty(prop));
        }
        temp.remove("password");
        this.vetoListeners_.fireVetoableChange("properties", this.properties_, temp);
        Properties old = this.properties_;
        this.properties2_ = properties;
        this.properties_ = temp;
        this.changeListeners_.firePropertyChange("properties", old, this.properties_);
    }

    public void setURL(String URL2) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (URL2 == null) {
            throw new NullPointerException("URL");
        }
        String old = this.getURL();
        this.vetoListeners_.fireVetoableChange("URL", old, URL2);
        this.url_ = this.url2_ = URL2;
        this.changeListeners_.firePropertyChange("URL", old, this.url_);
    }

    public void setUserName(String userName) throws PropertyVetoException {
        if (this.connection_ != null) {
            throw new IllegalStateException();
        }
        if (userName == null) {
            throw new NullPointerException("userName");
        }
        String old = this.getUserName();
        this.vetoListeners_.fireVetoableChange("userName", old, userName);
        this.uid_ = this.uid2_ = userName;
        this.changeListeners_.firePropertyChange("userName", old, this.uid_);
    }
}

