/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.testing.xp;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.testing.PipelineUnitTest;
import org.apache.hop.testing.UnitTestResult;
import org.apache.hop.testing.util.DataSetConst;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.hopgui.HopGui;

@ExtensionPoint(extensionPointId="PipelineFinish", id="ValidatePipelineUnitTestExtensionPoint", description="Inject a bunch of rows into a transform during preview")
public class ValidatePipelineUnitTestExtensionPoint
implements IExtensionPoint<IPipelineEngine<PipelineMeta>> {
    public static final Class<?> PKG = ValidatePipelineUnitTestExtensionPoint.class;

    public void callExtensionPoint(ILogChannel log, IVariables variables, IPipelineEngine<PipelineMeta> pipeline) throws HopException {
        PipelineMeta pipelineMeta = pipeline.getPipelineMeta();
        boolean runUnitTest = "Y".equalsIgnoreCase(pipeline.getVariable("__UnitTest_Run__"));
        if (!runUnitTest) {
            return;
        }
        String unitTestName = pipeline.getVariable("__UnitTest_Name__");
        if (StringUtil.isEmpty((String)unitTestName)) {
            return;
        }
        try {
            IHopMetadataProvider metadataProvider = pipelineMeta.getMetadataProvider();
            if (metadataProvider == null) {
                return;
            }
            PipelineUnitTest unitTest = (PipelineUnitTest)metadataProvider.getSerializer(PipelineUnitTest.class).load(unitTestName);
            ArrayList<UnitTestResult> results = new ArrayList<UnitTestResult>();
            pipeline.getExtensionDataMap().put("UnitTestResults", results);
            int errors = DataSetConst.validateTransformResultAgainstUnitTest(pipeline, unitTest, metadataProvider, results);
            if (errors == 0) {
                log.logBasic("Unit test '" + unitTest.getName() + "' passed successfully");
            } else {
                HopGui hopGui;
                log.logBasic("Unit test '" + unitTest.getName() + "' failed, " + errors + " errors detected, " + results.size() + " comments to report.");
                String dontShowResults = pipeline.getVariable("__UnitTest_DontShowUnitTestErrors__", "N");
                if ("N".equalsIgnoreCase(dontShowResults) && (hopGui = HopGui.getInstance()) != null) {
                    ValidatePipelineUnitTestExtensionPoint.showUnitTestErrors(pipeline, results, hopGui);
                }
            }
            log.logBasic("----------------------------------------------");
            for (UnitTestResult result : results) {
                if (result.getDataSetName() != null) {
                    log.logBasic(result.getTransformName() + " - " + result.getDataSetName() + " : " + result.getComment());
                    continue;
                }
                log.logBasic(result.getComment());
            }
            log.logBasic("----------------------------------------------");
        }
        catch (Throwable e) {
            log.logError("Unable to validate unit test/golden rows", e);
        }
    }

    public static final void showUnitTestErrors(IPipelineEngine<PipelineMeta> pipeline, List<UnitTestResult> results, HopGui hopGui) {
        hopGui.getShell().getDisplay().asyncExec(() -> {
            PreviewRowsDialog dialog = new PreviewRowsDialog(hopGui.getShell(), (IVariables)pipeline, 0, "Unit test results", UnitTestResult.getRowMeta(), UnitTestResult.getRowData(results));
            dialog.setDynamic(false);
            dialog.setProposingToGetMoreRows(false);
            dialog.setProposingToStop(false);
            dialog.setTitleMessage(BaseMessages.getString(PKG, (String)"UnitTestsResult.Dialog.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UnitTestsResult.Dialog.Message", (String[])new String[0]));
            dialog.open();
        });
    }
}

