/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

abstract class CustomOptional<@UnknownKeyFor T> {
    CustomOptional() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomOptional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized CustomOptional<T> of(T v) {
        return new Present(v);
    }

    public abstract @UnknownKeyFor @NonNull @Initialized boolean isPresent();

    public abstract T get();

    private static class Absent<@UnknownKeyFor T>
    extends CustomOptional<T> {
        private static final @UnknownKeyFor @NonNull @Initialized Absent<@UnknownKeyFor @NonNull @Initialized Object> INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isPresent() {
            return false;
        }

        @Override
        public T get() {
            throw new NoSuchElementException();
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            return o instanceof Absent;
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return 0;
        }
    }

    private static class Present<@UnknownKeyFor T>
    extends CustomOptional<T> {
        private final T value;

        private Present(T value) {
            this.value = value;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }

        @EnsuresNonNullIf(expression={"#1"}, result=true)
        @Pure
        public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
            if (!(o instanceof Present)) {
                return false;
            }
            Present present = (Present)o;
            return Objects.equals(this.value, present.value);
        }

        @Pure
        public @UnknownKeyFor @NonNull @Initialized int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

