/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.persistence.jpa;

import org.kie.api.KieBase;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class JPAKnowledgeService {
    private static KieStoreServices provider;

    public static StatefulKnowledgeSession newStatefulKnowledgeSession(KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        return (StatefulKnowledgeSession)JPAKnowledgeService.getJPAKnowledgeServiceProvider().newKieSession(kbase, configuration, environment);
    }

    @Deprecated
    public static StatefulKnowledgeSession loadStatefulKnowledgeSession(int id, KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        return (StatefulKnowledgeSession)JPAKnowledgeService.getJPAKnowledgeServiceProvider().loadKieSession(id, kbase, configuration, environment);
    }

    public static StatefulKnowledgeSession loadStatefulKnowledgeSession(Long id, KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        return (StatefulKnowledgeSession)JPAKnowledgeService.getJPAKnowledgeServiceProvider().loadKieSession(id, kbase, configuration, environment);
    }

    private static synchronized void setJPAKnowledgeServiceProvider(KieStoreServices provider) {
        JPAKnowledgeService.provider = provider;
    }

    private static synchronized KieStoreServices getJPAKnowledgeServiceProvider() {
        if (provider == null) {
            JPAKnowledgeService.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        String className = System.getProperty("org.kie.store.services.class", "org.drools.persistence.jpa.KnowledgeStoreServiceImpl");
        try {
            Class<?> cls = Class.forName(className);
            JPAKnowledgeService.setJPAKnowledgeServiceProvider((KieStoreServices)cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Provider " + className + " could not be set.", e);
        }
    }
}

