/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

public class NanoTime {
    private static final long ONE_HOUR = 3600000000000L;
    private static final long ONE_MINUTE = 60000000000L;
    private static final long ONE_SECOND = 1000000000L;
    private static final long ONE_MILLISECOND = 1000000L;
    private static final long ONE_MICROSECOND = 1000L;

    public static String formatTimeSince(long startTimeNs) {
        return NanoTime.format(System.nanoTime() - startTimeNs);
    }

    public static String format(long elapsedNs) {
        if (elapsedNs >= 3600000000000L) {
            long hours = elapsedNs / 3600000000000L;
            long minutes = elapsedNs % 3600000000000L / 60000000000L;
            return hours + " h " + minutes + " mn";
        }
        if (elapsedNs >= 60000000000L) {
            long minutes = elapsedNs / 60000000000L;
            long seconds = elapsedNs % 60000000000L / 1000000000L;
            return minutes + " mn " + seconds + " s";
        }
        if (elapsedNs >= 1000000000L) {
            long seconds = elapsedNs / 1000000000L;
            long milliseconds = elapsedNs % 1000000000L / 1000000L;
            return seconds + "." + milliseconds + " s";
        }
        if (elapsedNs >= 1000000L) {
            return elapsedNs / 1000000L + " ms";
        }
        if (elapsedNs >= 1000L) {
            return elapsedNs / 1000L + " us";
        }
        return elapsedNs + " ns";
    }
}

