/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.optimizer.operators;

import java.util.Collections;
import java.util.List;
import org.apache.flink.api.common.operators.Order;
import org.apache.flink.api.common.operators.Ordering;
import org.apache.flink.api.common.operators.util.FieldSet;
import org.apache.flink.optimizer.dag.SingleInputNode;
import org.apache.flink.optimizer.dataproperties.GlobalProperties;
import org.apache.flink.optimizer.dataproperties.LocalProperties;
import org.apache.flink.optimizer.dataproperties.PartitioningProperty;
import org.apache.flink.optimizer.dataproperties.RequestedGlobalProperties;
import org.apache.flink.optimizer.dataproperties.RequestedLocalProperties;
import org.apache.flink.optimizer.operators.OperatorDescriptorSingle;
import org.apache.flink.optimizer.plan.Channel;
import org.apache.flink.optimizer.plan.SingleInputPlanNode;
import org.apache.flink.runtime.operators.DriverStrategy;

public final class GroupCombineProperties
extends OperatorDescriptorSingle {
    private final Ordering ordering = new Ordering();

    public GroupCombineProperties(FieldSet groupKeys, Ordering additionalOrderKeys) {
        super(groupKeys);
        for (Integer key : this.keyList) {
            this.ordering.appendOrdering(key, null, Order.ANY);
        }
        if (additionalOrderKeys != null) {
            for (int i = 0; i < additionalOrderKeys.getNumberOfFields(); ++i) {
                Integer field = additionalOrderKeys.getFieldNumber(i);
                Order order = additionalOrderKeys.getOrder(i);
                this.ordering.appendOrdering(field, additionalOrderKeys.getType(i), order);
            }
        }
    }

    @Override
    public DriverStrategy getStrategy() {
        return DriverStrategy.SORTED_GROUP_COMBINE;
    }

    @Override
    public SingleInputPlanNode instantiate(Channel in, SingleInputNode node) {
        node.setParallelism(in.getSource().getParallelism());
        SingleInputPlanNode singleInputPlanNode = new SingleInputPlanNode(node, "GroupCombine (" + node.getOperator().getName() + ")", in, DriverStrategy.SORTED_GROUP_COMBINE, this.keyList);
        singleInputPlanNode.setDriverKeyInfo(this.ordering.getInvolvedIndexes(), this.ordering.getFieldSortDirections(), 0);
        singleInputPlanNode.setDriverKeyInfo(this.keyList, 1);
        return singleInputPlanNode;
    }

    @Override
    protected List<RequestedGlobalProperties> createPossibleGlobalProperties() {
        RequestedGlobalProperties props = new RequestedGlobalProperties();
        props.setRandomPartitioning();
        return Collections.singletonList(props);
    }

    @Override
    protected List<RequestedLocalProperties> createPossibleLocalProperties() {
        return Collections.singletonList(new RequestedLocalProperties());
    }

    @Override
    public GlobalProperties computeGlobalProperties(GlobalProperties gProps) {
        if (gProps.getUniqueFieldCombination() != null && gProps.getUniqueFieldCombination().size() > 0 && gProps.getPartitioning() == PartitioningProperty.RANDOM_PARTITIONED) {
            gProps.setAnyPartitioning(gProps.getUniqueFieldCombination().iterator().next().toFieldList());
        }
        gProps.clearUniqueFieldCombinations();
        return gProps;
    }

    @Override
    public LocalProperties computeLocalProperties(LocalProperties lProps) {
        return lProps.clearUniqueFieldSets();
    }
}

