/*
 * Decompiled with CFR 0.152.
 */
package io.crate.client.jdbc;

import io.crate.client.jdbc.CrateDriverVersion;
import io.crate.shade.org.postgresql.Driver;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class CrateDriver
extends Driver {
    private static final String PROTOCOL = "jdbc";
    private static final String CRATE_PROTOCOL = "crate";
    private static final String CRATE_PREFIX = "crate://";
    private static final String CRATE_PREFIX_LONG = "jdbc:crate://";
    private static final String PSQL_PROTOCOL = "postgresql";
    private static final String PSQL_PREFIX = "postgresql://";
    private static final String PSQL_PREFIX_LONG = "jdbc:postgresql://";
    private static java.sql.Driver registeredDriver;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        String psqlUrl = CrateDriver.processURL(url);
        if (psqlUrl == null) {
            return null;
        }
        return super.connect(psqlUrl, info);
    }

    static String processURL(String url) {
        if (url.startsWith(CRATE_PREFIX)) {
            url = String.format("%s:%s", PROTOCOL, url);
        } else if (!url.startsWith(CRATE_PREFIX_LONG)) {
            return null;
        }
        return url.replace(CRATE_PREFIX_LONG, PSQL_PREFIX_LONG);
    }

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(CRATE_PREFIX) || url.startsWith(CRATE_PREFIX_LONG);
    }

    @Override
    public int getMajorVersion() {
        return CrateDriverVersion.CURRENT.major;
    }

    @Override
    public int getMinorVersion() {
        return CrateDriverVersion.CURRENT.minor;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static void register() throws SQLException {
        if (CrateDriver.isRegistered()) {
            throw new IllegalStateException("Driver is already registered. It can only be registered once.");
        }
        CrateDriver crateDriver = new CrateDriver();
        DriverManager.registerDriver(crateDriver);
        registeredDriver = crateDriver;
    }

    public static void deregister() throws SQLException {
        if (!CrateDriver.isRegistered()) {
            throw new IllegalStateException("Driver is not registered (or it has not been registered using Driver.register() method)");
        }
        DriverManager.deregisterDriver(registeredDriver);
        registeredDriver = null;
    }

    public static boolean isRegistered() {
        return registeredDriver != null;
    }

    static {
        try {
            CrateDriver.register();
        }
        catch (SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

