/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.binary.bst;

import org.psjava.ds.tree.binary.BinaryTreeNodeUtil;
import org.psjava.ds.tree.binary.BinaryTreeNodeWithParent;
import org.psjava.ds.tree.binary.bst.MinimumFinder;

public class SuccessorFinder {
    public static <T> BinaryTreeNodeWithParent<T> findOrNull(BinaryTreeNodeWithParent<T> node) {
        if (node.hasRight()) {
            return MinimumFinder.find(node.getRight());
        }
        return SuccessorFinder.findLowestBiggerKeyAncestorOrNullRecursively(node);
    }

    private static <T> BinaryTreeNodeWithParent<T> findLowestBiggerKeyAncestorOrNullRecursively(BinaryTreeNodeWithParent<T> node) {
        if (node.hasParent()) {
            if (BinaryTreeNodeUtil.isLeftChild(node)) {
                return node.getParent();
            }
            return SuccessorFinder.findLowestBiggerKeyAncestorOrNullRecursively(node.getParent());
        }
        return null;
    }

    private SuccessorFinder() {
    }
}

