/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMutationVerbHandler<T extends IMutation>
implements IVerbHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMutationVerbHandler.class);
    private static final String logMessageTemplate = "Receiving mutation(s) for token(s) neither owned nor pending. Example: from {} for token {} in keyspace {}";

    @Override
    public void doVerb(Message<T> message) throws IOException {
        this.processMessage(message, message.from());
    }

    public void processMessage(Message<T> message, InetAddressAndPort respondTo) {
        boolean outOfRangeTokenLogging = DatabaseDescriptor.getLogOutOfTokenRangeRequests();
        boolean outOfRangeTokenRejection = DatabaseDescriptor.getRejectOutOfTokenRangeRequests();
        DecoratedKey key = ((IMutation)message.payload).key();
        boolean isOutOfRangeMutation = AbstractMutationVerbHandler.isOutOfRangeMutation(((IMutation)message.payload).getKeyspaceName(), key);
        if (isOutOfRangeMutation) {
            StorageService.instance.incOutOfRangeOperationCount();
            Keyspace.open((String)((IMutation)message.payload).getKeyspaceName()).metric.outOfRangeTokenWrites.inc();
            if (outOfRangeTokenLogging) {
                NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.SECONDS, logMessageTemplate, respondTo, key.getToken(), ((IMutation)message.payload).getKeyspaceName());
            }
        }
        if (outOfRangeTokenRejection && isOutOfRangeMutation) {
            this.sendFailureResponse(message, respondTo);
        } else {
            this.applyMutation(message, respondTo);
        }
    }

    abstract void applyMutation(Message<T> var1, InetAddressAndPort var2);

    private void sendFailureResponse(Message<T> respondTo, InetAddressAndPort respondToAddress) {
        MessagingService.instance().send(respondTo.failureResponse(RequestFailureReason.UNKNOWN), respondToAddress);
    }

    private static boolean isOutOfRangeMutation(String keyspace, DecoratedKey key) {
        return !StorageService.instance.isEndpointValidForWrite(keyspace, key.getToken());
    }
}

