/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.HashSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.functions.CollatingFunctionFixed;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Action;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class DistinctValues
extends CollatingFunctionFixed {
    public static final AtomicMatchKey NaN_MATCH_KEY = new QNameValue("", NamespaceUri.SAXON, "+NaN+");

    @Override
    public String getStreamerName() {
        return "DistinctValues";
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringCollator collator = this.getStringCollator();
        return new LazySequence(new DistinctIterator(arguments[0].iterate(), collator, context));
    }

    public static class DistinctIterator
    implements SequenceIterator {
        private final SequenceIterator base;
        private final StringCollator collator;
        private final XPathContext context;
        private final HashSet<AtomicMatchKey> lookup = new HashSet(40);
        private Action onDuplicates = null;

        public DistinctIterator(SequenceIterator base, StringCollator collator, XPathContext context) {
            this.base = base;
            this.collator = collator;
            this.context = context;
        }

        @Override
        public AtomicValue next() {
            int implicitTimezone = this.context.getImplicitTimezone();
            AtomicValue nextBase;
            while ((nextBase = (AtomicValue)this.base.next()) != null) {
                AtomicMatchKey key;
                if (nextBase.isNaN()) {
                    key = NaN_MATCH_KEY;
                } else {
                    try {
                        key = nextBase.getXPathMatchKey(this.collator, implicitTimezone);
                    }
                    catch (NoDynamicContextException e) {
                        throw new UncheckedXPathException(e);
                    }
                }
                if (this.lookup.add(key)) {
                    return nextBase;
                }
                if (this.onDuplicates == null) continue;
                try {
                    this.onDuplicates.doAction();
                }
                catch (XPathException e) {
                    throw new UncheckedXPathException(e);
                }
            }
            return null;
        }

        @Override
        public void close() {
            this.base.close();
        }

        public void notifyDuplicates(Action onDuplicates) {
            this.onDuplicates = onDuplicates;
        }
    }
}

