/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.UnicodeStringEvaluator;
import net.sf.saxon.functions.ScalarSystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;

public class StringLength_1
extends ScalarSystemFunction {
    @Override
    public IntegerValue[] getIntegerBounds() {
        return new IntegerValue[]{Int64Value.ZERO, Expression.MAX_STRING_LENGTH};
    }

    @Override
    public Sequence resultWhenEmpty() {
        return Int64Value.ZERO;
    }

    @Override
    public AtomicValue evaluate(Item arg, XPathContext context) throws XPathException {
        UnicodeString s;
        if (arg instanceof StringValue) {
            return Int64Value.makeIntegerValue(((StringValue)arg).length());
        }
        try {
            s = arg.getUnicodeStringValue();
        }
        catch (UnsupportedOperationException e) {
            throw new XPathException("Cannot get the string value of a function item", "FOTY0013");
        }
        return Int64Value.makeIntegerValue(s.length());
    }

    @Override
    public Elaborator getElaborator() {
        return new StringLengthFnElaborator();
    }

    public static class StringLengthFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            Expression arg = fnc.getArg(0);
            UnicodeStringEvaluator argEval = arg.makeElaborator().elaborateForUnicodeString(true);
            return context -> {
                UnicodeString str = argEval.eval(context);
                return Int64Value.makeIntegerValue(str.length());
            };
        }
    }
}

