/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.symbolsolver.resolution.typeinference.bounds;

import com.github.javaparser.resolution.types.ResolvedType;
import com.github.javaparser.symbolsolver.resolution.typeinference.Bound;
import com.github.javaparser.symbolsolver.resolution.typeinference.InferenceVariable;
import com.github.javaparser.symbolsolver.resolution.typeinference.InferenceVariableSubstitution;
import com.github.javaparser.symbolsolver.resolution.typeinference.ProperLowerBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.ProperUpperBound;
import com.github.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class SubtypeOfBound
extends Bound {
    private ResolvedType s;
    private ResolvedType t;

    public SubtypeOfBound(ResolvedType s, ResolvedType t) {
        if (!s.isInferenceVariable() && !t.isInferenceVariable()) {
            throw new IllegalArgumentException("One of S or T should be an inference variable");
        }
        this.s = s;
        this.t = t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtypeOfBound that = (SubtypeOfBound)o;
        if (!this.s.equals(that.s)) {
            return false;
        }
        return this.t.equals(that.t);
    }

    public String toString() {
        return "SubtypeOfBound{s=" + this.s + ", t=" + this.t + '}';
    }

    public int hashCode() {
        int result = this.s.hashCode();
        result = 31 * result + this.t.hashCode();
        return result;
    }

    public ResolvedType getS() {
        return this.s;
    }

    @Override
    public Set<InferenceVariable> usedInferenceVariables() {
        HashSet<InferenceVariable> variables = new HashSet<InferenceVariable>();
        variables.addAll(TypeHelper.usedInferenceVariables(this.s));
        variables.addAll(TypeHelper.usedInferenceVariables(this.t));
        return variables;
    }

    public ResolvedType getT() {
        return this.t;
    }

    @Override
    public Optional<ProperUpperBound> isProperUpperBound() {
        if (this.s.isInferenceVariable() && TypeHelper.isProperType(this.t)) {
            return Optional.of(new ProperUpperBound((InferenceVariable)this.s, this.t));
        }
        return Optional.empty();
    }

    @Override
    public Optional<ProperLowerBound> isProperLowerBound() {
        if (TypeHelper.isProperType(this.s) && this.t.isInferenceVariable()) {
            return Optional.of(new ProperLowerBound((InferenceVariable)this.t, this.s));
        }
        return Optional.empty();
    }

    @Override
    public boolean isADependency() {
        return !this.isProperLowerBound().isPresent() && !this.isProperUpperBound().isPresent();
    }

    @Override
    public boolean isSatisfied(InferenceVariableSubstitution inferenceVariableSubstitution) {
        throw new UnsupportedOperationException();
    }
}

