/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.time.Instant;
import javax.servlet.http.Cookie;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.protocol.http.IMetaDataBufferingWebResponse;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.util.lang.Args;

class HeaderBufferingWebResponse
extends WebResponse
implements IMetaDataBufferingWebResponse {
    private final WebResponse originalResponse;
    private final BufferedWebResponse bufferedResponse;
    private boolean buffering = true;

    public HeaderBufferingWebResponse(WebResponse originalResponse) {
        this.originalResponse = originalResponse;
        this.bufferedResponse = new BufferedWebResponse(originalResponse);
    }

    private void stopBuffering() {
        if (this.buffering) {
            this.bufferedResponse.writeTo(this.originalResponse);
            this.buffering = false;
        }
    }

    private WebResponse getMetaResponse() {
        if (this.buffering) {
            return this.bufferedResponse;
        }
        return this.originalResponse;
    }

    public void addCookie(Cookie cookie) {
        this.getMetaResponse().addCookie(cookie);
    }

    public void clearCookie(Cookie cookie) {
        this.getMetaResponse().clearCookie(cookie);
    }

    public void flush() {
        this.stopBuffering();
        this.originalResponse.flush();
    }

    public boolean isRedirect() {
        return this.getMetaResponse().isRedirect();
    }

    public void sendError(int sc, String msg) {
        this.getMetaResponse().sendError(sc, msg);
    }

    public void sendRedirect(String url) {
        this.getMetaResponse().sendRedirect(url);
    }

    public void setContentLength(long length) {
        this.getMetaResponse().setContentLength(length);
    }

    public void setContentType(String mimeType) {
        this.getMetaResponse().setContentType(mimeType);
    }

    public void setDateHeader(String name, Instant date) {
        Args.notNull((Object)date, (String)"date");
        this.getMetaResponse().setDateHeader(name, date);
    }

    public boolean isHeaderSupported() {
        return this.getMetaResponse().isHeaderSupported();
    }

    public void setHeader(String name, String value) {
        this.getMetaResponse().setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.getMetaResponse().addHeader(name, value);
    }

    public void setStatus(int sc) {
        this.getMetaResponse().setStatus(sc);
    }

    public void disableCaching() {
        this.getMetaResponse().disableCaching();
    }

    public String encodeURL(CharSequence url) {
        return this.originalResponse.encodeURL(url);
    }

    public String encodeRedirectURL(CharSequence url) {
        return this.originalResponse.encodeRedirectURL(url);
    }

    public void write(CharSequence sequence) {
        this.stopBuffering();
        this.originalResponse.write(sequence);
    }

    public void write(byte[] array) {
        this.stopBuffering();
        this.originalResponse.write(array);
    }

    public void write(byte[] array, int offset, int length) {
        this.stopBuffering();
        this.originalResponse.write(array, offset, length);
    }

    public void reset() {
        if (!this.buffering) {
            throw new IllegalStateException("Response is no longer buffering!");
        }
        this.bufferedResponse.reset();
    }

    @Override
    public void writeMetaData(WebResponse webResponse) {
        this.bufferedResponse.writeMetaData(webResponse);
    }

    public Object getContainerResponse() {
        return this.originalResponse.getContainerResponse();
    }
}

